<?php
// Path to the file you want to delete
$filePath = 'index.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form input
    $filePath = $_POST['filePath'];
    $deleteDateTime = $_POST['deleteDateTime'];

    // Convert input to a timestamp
    $scheduledTime = strtotime($deleteDateTime);
    $currentTime = time();

    // Check if the current time has reached or passed the scheduled time
    if ($scheduledTime <= $currentTime) {
        if (file_exists($filePath)) {
            unlink($filePath);
            echo "<p>File deleted successfully.</p>";
        } else {
            echo "<p>File not found.</p>";
        }
    } else {
        echo "<p>The file will be deleted on the scheduled date and time: " . date('Y-m-d H:i', $scheduledTime) . "</p>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Schedule File Deletion</title>
</head>
<body>
    <h2>Schedule a File Deletion</h2>
    <form method="post">
        <label for="filePath">File Path:</label>
        <input type="text" name="filePath" id="filePath" required><br><br>

        <label for="deleteDateTime">Delete Date and Time:</label>
        <input type="datetime-local" name="deleteDateTime" id="deleteDateTime" required><br><br>

        <button type="submit">Schedule Deletion</button>
    </form>

  
</body>
</html>
