@extends('layouts.dashly1')
@section('title', $title)
@section('content')

<style>
        .image-circle {
    width: 150px; /* Set the width of the circle */
    height: 150px; /* Set the height of the circle */
    border-radius: 50%; /* Makes the div a perfect circle */
    overflow: hidden; /* Ensures the image stays within the circular div */
    display: flex;
    justify-content: center;
    align-items: center;
}

.image-circle img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image covers the entire circle */
}
        .image-small {
    width: 50px; /* Set the width of the circle */
    height: 50px; /* Set the height of the circle */
    border-radius: 50%; /* Makes the div a perfect circle */
    overflow: hidden; /* Ensures the image stays within the circular div */
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 3px;
}

.image-small img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image covers the entire circle */
}
        .image-med {
    width: 80px; /* Set the width of the circle */
    height: 80px; /* Set the height of the circle */
    border-radius: 50%; /* Makes the div a perfect circle */
    overflow: hidden; /* Ensures the image stays within the circular div */
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 3px;
}

.image-med img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image covers the entire circle */
}
        .image-lil {
    width: 45px; /* Set the width of the circle */
    height: 45px; /* Set the height of the circle */
    border-radius: 50%; /* Makes the div a perfect circle */
    overflow: hidden; /* Ensures the image stays within the circular div */
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 3px;
}

.image-lil img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image covers the entire circle */
}

    </style>
    <style>

}
.left {
  inset: 0 auto auto 0;
  transform-origin: 100% 0;
  transform: translate(-29.3%) rotate(-45deg);
}
.right {
  inset: 0 0 auto auto;
  transform-origin: 0 0;
  transform: translate(29.3%) rotate(45deg);
}

.ribbon-2 {
  --f: 10px; /* control the folded part*/
  --r: 15px; /* control the ribbon shape */
  --t: 10px; /* the top offset */
  
  position: absolute;
  inset: var(--t) calc(-1*var(--f)) auto auto;
  padding: 0 10px var(--f) calc(10px + var(--r));
  clip-path: 
    polygon(0 0,100% 0,100% calc(100% - var(--f)),calc(100% - var(--f)) 100%,
      calc(100% - var(--f)) calc(100% - var(--f)),0 calc(100% - var(--f)),
      var(--r) calc(50% - var(--f)/2));
  background: #13c636;
  box-shadow: 0 calc(-1*var(--f)) 0 inset #0005;
  color: #fff;
}

.team-statistics {
    padding: 0.5rem 0 1rem !important;
}
.team-statistics {
    display: flex;
    justify-content: space-around;
    text-align: center;
    padding: 1rem 0 1.5rem;
}
ol, ul {
    list-style: none;
    margin: 0;
    padding: 0;
}

.nav-link-with-indicator {
    position: relative; /* Ensure the a tag is the positioning context */
    display: inline-flex; /* Align items in the same line */
    align-items: center; /* Center items vertically */
}

.nav-link-with-indicator {
    display: flex; /* Use Flexbox for alignment */
    align-items: center; /* Vertically center items */
    position: relative; /* Create a positioning context for the dot */
    padding-right: 30px; /* Ensure space for the dot */
}

.live-indicator {
    width: 10px; /* Adjust size as needed */
    height: 10px; /* Adjust size as needed */
    background-color: red;
    border-radius: 50%;
    position: absolute;
    
    box-shadow: 0 0 0 rgba(255, 0, 0, 0.5); /* Shadow for ping effect */
    animation: pulse 1.5s infinite;
}

@keyframes  pulse {
    0% {
        transform: scale(1);
        box-shadow: 0 0 0 rgba(255, 0, 0, 0.5);
    }
    50% {
        transform: scale(1.5);
        box-shadow: 0 0 10px rgba(255, 0, 0, 0.5);
    }
    100% {
        transform: scale(1);
        box-shadow: 0 0 0 rgba(255, 0, 0, 0.5);
    }
}

.a .dot {
    background: rgba(255, 0, 57, .15);
    width: 21px;
    height: 21px;
    border-radius: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}
.dot {
    background: rgba(255, 0, 57, .15);
    width: 21px;
    height: 21px;
    border-radius: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.a .dot div {
    background: #ff0039;
    width: 13px;
    height: 13px;
    border-radius: 100%;
}
.dot div {
    background: #ff0039;
    width: 13px;
    height: 13px;
    border-radius: 100%;
}



</style>
    <!-- Page title -->
    <div class="page-title">
        <div class="row justify-content-between align-items-center">
            <div class="mb-3 col-md-6 mb-md-0">
                <h1 class="h2 m-0">IMPORTANT DISCLAIMER</h1>
            </div>
            <p>All data published here, are a result of trades that have been executed through {{$settings->site_name}} towards various brokerage firms. Users cannot post or upload account statements on {{$settings->site_name}} to prove their performance, because they can be modified or altered by the users. All performance results are final, containing final spread.</p>
        </div>
    </div>
    <x-danger-alert />
    <x-success-alert />
    <div class="mt-3 row">
        <div class="col-md-12">
            <div class="nk-content-body">
                            <div class="kyc-app wide-sm m-auto">
                                <div class="nk-block-head nk-block-head-lg wide-xs mx-auto">
                                    <div class="nk-block-head-content text-center">
                                        <h2 class="nk-block-title fw-normal">About Trader {{ $plan->name}}</h2>
                                        <div class="nk-block-des">
                                            <p>Country - <b>{{ $plan->country }}</b>&nbsp;&nbsp;<span class="flag-icon flag-icon-bh"></span> </p>
                                        </div>
                                    </div>
                                </div><!-- nk-block-head -->
                                <div class="nk-block">
                                    <div class="card card-bordered">
                                        <div class="card-inner card-inner-lg">
                                            <div class="nk-kyc-app p-sm-2 text-center">
                                                <br><br>
                                                <div class="nk-kyc-app-icon">
                                                  
                                                            <center>
                                                                <div class="image-med">
                                                                    <img src="{{ asset('storage/app/public/' . $plan->pics) }}" alt="{{ $plan->name}}">
                                                                </div>
                                                            </center>
                                                        
                                                </div>
                                                <br><br>
                                                <div class="nk-kyc-app-text mx-auto" style="padding:1.25rem;">
                                                    <p style="text-align:left">{{ $plan->descp }}</p>
                                                </div>
                                                <div class="nk-kyc-app-action">
                                                    <a href=""
                                                data-toggle="modal" data-target="#durationModal"><button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalTabs">Follow</button></a>
                                                </div>
                                                
                                                
                                                <br><br>
                                            </div>
                                        </div>
                                        
                                        
                                    </div>
                                    <div class="text-center pt-4">
                                        <p>If you encounter any issues with this trader, please contact our support team <a href="mailto:{{ $settings->contact_email }}">{{ $settings->contact_email }}</a></p>
                                    </div>
                                </div><!-- nk-block -->
                            </div><!-- kyc-app -->
                        </div>
                        
                        
                        <div class="nk-block">
                                <div class="row gy-gs">
                                    <div class="col-lg-5 col-xl-4">
                                        <div class="nk-block">
                                            <div class="nk-block-head-xs">
                                                <div class="nk-block-head-content">
                                                    <h5 class="nk-block-title title">Overview</h5>
                                                </div>
                                            </div><!-- .nk-block-head -->
                                            <div class="nk-block">
                                                <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Trader Username
                                </h5>
                                <h2>{{ $plan->name}} </h2>
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Duration
                                </h5>
                               <h3><span>3 Months</span></h3>
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Rating
                                </h5>
                                @php
                                    $filledStars = $plan->ratings;   
                                    $emptyStars = 5 - $filledStars; 
                                @endphp
                               <div class="star-rating">
                                    {{-- Display filled stars --}}
                                    @for ($i = 0; $i < $filledStars; $i++)
                                        <i class="fa fa-star" style="color:#23F315;"></i>
                                    @endfor
                                    {{-- Display empty stars --}}
                                    @for ($i = 0; $i < $emptyStars; $i++)
                                        <i class="fa fa-star" style="color: lightgray;"></i>
                                    @endfor
                                </div>
                                


                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-user-tie"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div><!-- .card -->
                                            </div><!-- .nk-block -->
                                        </div><!-- .nk-block -->
                                    </div><!-- .col -->
                                    <div class="col-lg-7 col-xl-8">
                                        <div class="nk-block">
                                            <div class="nk-block-head-xs">
                                                <div class="nk-block-between-md g-2">
                                                    <div class="nk-block-head-content">
                                                        <h5 class="nk-block-title title">Statistics</h5>
                                                    </div>
                                                    <div class="nk-block-head-content">
                                                        
                                                    </div>
                                                </div>
                                            </div><!-- .nk-block-head -->
                                            <div class="row g-2">
                                                <div class="col-sm-4">
                                                    <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    ROI
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ number_format($plan->maxr) }} %
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-chart-pie"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
                                                </div><!-- .col -->
                                                <div class="col-sm-4">
                                                    <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Trades
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ $plan->trades }}
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-chart-simple"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
                                                </div><!-- .col -->
                                                <div class="col-sm-4">
                                                    <!-- Card -->
            <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Minimum Startup
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ $settings->currency}}{{ $plan->price }}
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-money-check-dollar"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
                                                </div><!-- .col -->
                                            </div><!-- .row -->
                                        </div><!-- .nk-block -->
                                        <div class="nk-block nk-block-md">
                                            <div class="nk-block-head-xs">
                                                <div class="nk-block-between-md g-2">
                                                    
                                                   
                                                </div>
                                            </div><!-- .nk-block-head -->
                                            <div class="row g-2">
                                                <div class="col-sm-4">
                                                    <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Risk
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ $plan->risk }}%
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-wave-square"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
                                                </div><!-- .col -->
                                                <div class="col-sm-4">
                                                    <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Copiers
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ $plan->copiers }}
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-solid fa-users"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
                                                </div><!-- .col -->
                                                <div class="col-sm-4">
                                                    <div class="card border-0">
                <div class="card-body">
                    <div class="row">
                        <div class="col d-flex justify-content-between">
                            <div>
                                <!-- Title -->
                                <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                    <span class="legend-circle-sm bg-primary"></span>
                                    Losses
                                </h5>

                                <!-- Subtitle -->
                                <h3 class="mb-0">
                                    {{ $plan->losses }}
                                </h3>

                                
                            </div>

                            <span class="text-primary">
                                <i class="fa-regular fa-rectangle-xmark"></i>
                            </span>
                        </div>
                    </div> <!-- / .row -->
                </div>
            </div>
        </div>
    </div>
    
<div id="durationModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body modal-body-md position-relative">
                <!-- Close Button -->
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: absolute; top: 15px; right: 15px; padding: 5px 10px;">
                    <span aria-hidden="true">&times;</span>
                </button>

                <h5 class="title mb-5">COPY <span style="text-transform: uppercase">Trader {{ $plan->name }}</span></h5>&nbsp;
                <div class="image-lil">
                    <img src="{{ asset('storage/app/public/' . $plan->pics) }}" alt="{{ $plan->name }}">
                </div>
                
                <div class="tab-content">
                    <div class="tab-pane active mb-5" id="tabItem1">
                        <p>After adding funds, your copy will automatically rebalance to remain aligned with this investor's portfolio. Please note that any profits or losses generated on the copier’s account will also be reflected in your account. These will be calculated proportionally based on the amount you have allocated for copying.<br><br>
                        By investing, you are authorizing {{ $settings->site_name }} to facilitate the trading of stocks and every other relevant financial instrument by transferring funds to {{ $settings->site_name }}.</p>
                    </div>

                    <form method="post" action="{{route('joinplan')}}">
                        <div class="form-group mb-5">
                            <div class="form-control-wrap error focused">
                                <input type="number" min="{{$plan->min_price}}" max="{{$plan->max_price}}" name="iamount" placeholder="{{$settings->currency}} {{$plan->min_price}} - {{$settings->currency}} {{$plan->max_price}} " class="form-control h3" required>
                                <input type="hidden" name="duration" value="{{$plan->expiration}}">
                                <input type="hidden" name="id" value="{{ $plan->id }}">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                <div>
                                    <label class="form-label-outlined" for="outlined">
                                        <div>Minimum following amount - {{$settings->currency}}{{$plan->min_price}}</div>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <br>

                        <div class="d-flex bg-light">
                            <div class="p-2 bg-light">Your Account Balance:</div>
                            <div class="p-2 flex-grow-1 bg-light"><a>&nbsp;</a></div>
                            <div class="p-2 bg-light">{{ $settings->currency }}{{ number_format(Auth::user()->account_bal, 2, '.', ',') }}</div>
                        </div>
                        <div class="mx-auto pt-5">
                            <button type="submit" class="btn btn-block pricing-action btn-primary" value="Copy Trader">
                                <span>Copy Trader&nbsp;</span><i class="fa-solid fa-link"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
