@extends('layouts.dashly1')
@section('title', $title)
@section('content')
 <style>
      @charset  "UTF-8";

@media (prefers-reduced-motion: reduce) { .modal.fade .modal-dialog { transition: none; } }

.modal.show .modal-dialog { transform: none !important; }

.modal.modal-static .modal-dialog { transform: scale(0.95); }

.modal-dialog-scrollable { display: flex; max-height: calc(100% - 1rem); }

.modal-dialog-scrollable .modal-content { max-height: calc(100vh - 1rem); overflow: hidden; }

.modal-dialog-scrollable .modal-header, .modal-dialog-scrollable .modal-footer { flex-shrink: 0; }

.modal-dialog-scrollable .modal-body { overflow-y: auto; }

.modal-dialog-centered { display: flex; align-items: center; min-height: calc(100% - 1rem); }

.modal-dialog-centered::before { display: block; height: calc(100vh - 1rem); height: min-content; content: ""; }

.modal-dialog-centered.modal-dialog-scrollable { flex-direction: column; justify-content: center; height: 100%; }

.modal-dialog-centered.modal-dialog-scrollable .modal-content { max-height: none; }

.modal-dialog-centered.modal-dialog-scrollable::before { content: none; }

.modal-content { position: relative; display: flex; flex-direction: column; width: 100%; pointer-events: auto; background-color: #fff; background-clip: padding-box; border: 0 solid rgba(0, 0, 0, 0); border-radius: 5px; outline: 0; }

.modal-backdrop { position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #364a63; }

.modal-backdrop.fade { opacity: 0; }

.modal-backdrop.show { opacity: 0.5; }

.modal-header { display: flex; align-items: flex-start; justify-content: space-between; padding: 1rem 1.25rem; border-bottom: 1px solid #dbdfea; border-top-left-radius: 4px; border-top-right-radius: 4px; }

.modal-header .close { padding: 1rem 1.25rem; margin: -1rem -1.25rem -1rem auto; }

.modal-title { margin-bottom: 0; line-height: 1.5; }

.modal-body { position: relative; flex: 1 1 auto; padding: 1.25rem; }

.modal-footer { display: flex; flex-wrap: wrap; align-items: center; justify-content: flex-end; padding: 1rem; border-top: 1px solid #dbdfea; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px; }

.modal-footer > * { margin: 0.25rem; }

.modal-scrollbar-measure { position: absolute; top: -9999px; width: 50px; height: 50px; overflow: scroll; }

@media (min-width: 576px) { .modal-dialog { max-width: 520px; margin: 1.75rem auto; }
  .modal-dialog-scrollable { max-height: calc(100% - 3.5rem); }
  .modal-dialog-scrollable .modal-content { max-height: calc(100vh - 3.5rem); }
  .modal-dialog-centered { min-height: calc(100% - 3.5rem); }
  .modal-dialog-centered::before { height: calc(100vh - 3.5rem); height: min-content; }
  .modal-sm { max-width: 360px; } }

@media (min-width: 992px) { .modal-lg, .modal-xl { max-width: 720px; } }

@media (min-width: 1200px) { .modal-xl { max-width: 980px; } }

.rounded-pill { border-radius: 1.5rem !important; }

.rounded-0 { border-radius: 0 !important; }

.clearfix::after { display: block; clear: both; content: ""; }

.d-none { display: none !important; }

.d-inline { display: inline !important; }

.d-inline-block { display: inline-block !important; }

.d-block { display: block !important; }

.d-table { display: table !important; }

.d-table-row { display: table-row !important; }

.d-table-cell { display: table-cell !important; }

.d-flex, .align-start, .align-end, .align-center, .justify-start, .justify-end, .justify-center, .justify-between, .justify-around, .between-start, .between-center, .center, .stretch { display: flex !important; }

.d-inline-flex { display: inline-flex !important; }

@media (min-width: 576px) { .d-sm-none { display: none !important; }
  .d-sm-inline { display: inline !important; }
  .d-sm-inline-block { display: inline-block !important; }
  .d-sm-block { display: block !important; }
  .d-sm-table { display: table !important; }
  .d-sm-table-row { display: table-row !important; }
  .d-sm-table-cell { display: table-cell !important; }
  .d-sm-flex { display: flex !important; }
  .d-sm-inline-flex { display: inline-flex !important; } }

@media (min-width: 768px) { .d-md-none { display: none !important; }
  .d-md-inline { display: inline !important; }
  .d-md-inline-block { display: inline-block !important; }
  .d-md-block { display: block !important; }
  .d-md-table { display: table !important; }
  .d-md-table-row { display: table-row !important; }
  .d-md-table-cell { display: table-cell !important; }
  .d-md-flex { display: flex !important; }
  .d-md-inline-flex { display: inline-flex !important; } }

@media (min-width: 992px) { .d-lg-none { display: none !important; }
  .d-lg-inline { display: inline !important; }
  .d-lg-inline-block { display: inline-block !important; }
  .d-lg-block { display: block !important; }
  .d-lg-table { display: table !important; }
  .d-lg-table-row { display: table-row !important; }
  .d-lg-table-cell { display: table-cell !important; }
  .d-lg-flex { display: flex !important; }
  .d-lg-inline-flex { display: inline-flex !important; } }

@media (min-width: 1200px) { .d-xl-none { display: none !important; }
  .d-xl-inline { display: inline !important; }
  .d-xl-inline-block { display: inline-block !important; }
  .d-xl-block { display: block !important; }
  .d-xl-table { display: table !important; }
  .d-xl-table-row { display: table-row !important; }
  .d-xl-table-cell { display: table-cell !important; }
  .d-xl-flex { display: flex !important; }
  .d-xl-inline-flex { display: inline-flex !important; } }

@media (min-width: 1540px) { .d-xxl-none { display: none !important; }
  .d-xxl-inline { display: inline !important; }
  .d-xxl-inline-block { display: inline-block !important; }
  .d-xxl-block { display: block !important; }
  .d-xxl-table { display: table !important; }
  .d-xxl-table-row { display: table-row !important; }
  .d-xxl-table-cell { display: table-cell !important; }
  .d-xxl-flex { display: flex !important; }
  .d-xxl-inline-flex { display: inline-flex !important; } }

@media  print { .d-print-none { display: none !important; }
  .d-print-inline { display: inline !important; }
  .d-print-inline-block { display: inline-block !important; }
  .d-print-block { display: block !important; }
  .d-print-table { display: table !important; }
  .d-print-table-row { display: table-row !important; }
  .d-print-table-cell { display: table-cell !important; }
  .d-print-flex { display: flex !important; }
  .d-print-inline-flex { display: inline-flex !important; } }

.embed-responsive { position: relative; display: block; width: 100%; padding: 0; overflow: hidden; }

.embed-responsive::before { display: block; content: ""; }

.embed-responsive .embed-responsive-item, .embed-responsive iframe, .embed-responsive embed, .embed-responsive object, .embed-responsive video { position: absolute; top: 0; bottom: 0; left: 0; width: 100%; height: 100%; border: 0; }

.embed-responsive-21by9::before { padding-top: 42.85714%; }

.embed-responsive-16by9::before { padding-top: 56.25%; }

.embed-responsive-4by3::before { padding-top: 75%; }

.embed-responsive-1by1::before { padding-top: 100%; }

.flex-row { flex-direction: row !important; }

.flex-column { flex-direction: column !important; }

.flex-row-reverse { flex-direction: row-reverse !important; }

.flex-column-reverse { flex-direction: column-reverse !important; }

.flex-wrap { flex-wrap: wrap !important; }

.flex-nowrap { flex-wrap: nowrap !important; }

.flex-wrap-reverse { flex-wrap: wrap-reverse !important; }

.flex-fill { flex: 1 1 auto !important; }

.flex-grow-0 { flex-grow: 0 !important; }

.flex-grow-1 { flex-grow: 1 !important; }

.flex-shrink-0 { flex-shrink: 0 !important; }

.flex-shrink-1 { flex-shrink: 1 !important; }

.justify-content-start, .justify-start { justify-content: flex-start !important; }

.justify-content-end, .justify-end { justify-content: flex-end !important; }

.justify-content-center, .justify-center, .center { justify-content: center !important; }

.justify-content-between, .justify-between, .between-start, .between-center { justify-content: space-between !important; }

.justify-content-around, .justify-around { justify-content: space-around !important; }

.align-items-start, .align-start, .between-start { align-items: flex-start !important; }

.align-items-end, .align-end { align-items: flex-end !important; }

.align-items-center, .align-center, .between-center, .center { align-items: center !important; }

.align-items-baseline { align-items: baseline !important; }

.align-items-stretch, .stretch { align-items: stretch !important; }

.align-content-start { align-content: flex-start !important; }

.align-content-end { align-content: flex-end !important; }

.align-content-center { align-content: center !important; }

.align-content-between { align-content: space-between !important; }

.align-content-around { align-content: space-around !important; }

.align-content-stretch { align-content: stretch !important; }

.align-self-auto { align-self: auto !important; }

.align-self-start { align-self: flex-start !important; }

.align-self-end { align-self: flex-end !important; }

.align-self-center { align-self: center !important; }

.align-self-baseline { align-self: baseline !important; }

.align-self-stretch { align-self: stretch !important; }

@media (min-width: 576px) { .flex-sm-row { flex-direction: row !important; }
  .flex-sm-column { flex-direction: column !important; }
  .flex-sm-row-reverse { flex-direction: row-reverse !important; }
  .flex-sm-column-reverse { flex-direction: column-reverse !important; }
  .flex-sm-wrap { flex-wrap: wrap !important; }
  .flex-sm-nowrap { flex-wrap: nowrap !important; }
  .flex-sm-wrap-reverse { flex-wrap: wrap-reverse !important; }
  .flex-sm-fill { flex: 1 1 auto !important; }
  .flex-sm-grow-0 { flex-grow: 0 !important; }
  .flex-sm-grow-1 { flex-grow: 1 !important; }
  .flex-sm-shrink-0 { flex-shrink: 0 !important; }
  .flex-sm-shrink-1 { flex-shrink: 1 !important; }
  .justify-content-sm-start { justify-content: flex-start !important; }
  .justify-content-sm-end { justify-content: flex-end !important; }
  .justify-content-sm-center { justify-content: center !important; }
  .justify-content-sm-between { justify-content: space-between !important; }
  .justify-content-sm-around { justify-content: space-around !important; }
  .align-items-sm-start { align-items: flex-start !important; }
  .align-items-sm-end { align-items: flex-end !important; }
  .align-items-sm-center { align-items: center !important; }
  .align-items-sm-baseline { align-items: baseline !important; }
  .align-items-sm-stretch { align-items: stretch !important; }
  .align-content-sm-start { align-content: flex-start !important; }
  .align-content-sm-end { align-content: flex-end !important; }
  .align-content-sm-center { align-content: center !important; }
  .align-content-sm-between { align-content: space-between !important; }
  .align-content-sm-around { align-content: space-around !important; }
  .align-content-sm-stretch { align-content: stretch !important; }
  .align-self-sm-auto { align-self: auto !important; }
  .align-self-sm-start { align-self: flex-start !important; }
  .align-self-sm-end { align-self: flex-end !important; }
  .align-self-sm-center { align-self: center !important; }
  .align-self-sm-baseline { align-self: baseline !important; }
  .align-self-sm-stretch { align-self: stretch !important; } }

@media (min-width: 768px) { .flex-md-row { flex-direction: row !important; }
  .flex-md-column { flex-direction: column !important; }
  .flex-md-row-reverse { flex-direction: row-reverse !important; }
  .flex-md-column-reverse { flex-direction: column-reverse !important; }
  .flex-md-wrap { flex-wrap: wrap !important; }
  .flex-md-nowrap { flex-wrap: nowrap !important; }
  .flex-md-wrap-reverse { flex-wrap: wrap-reverse !important; }
  .flex-md-fill { flex: 1 1 auto !important; }
  .flex-md-grow-0 { flex-grow: 0 !important; }
  .flex-md-grow-1 { flex-grow: 1 !important; }
  .flex-md-shrink-0 { flex-shrink: 0 !important; }
  .flex-md-shrink-1 { flex-shrink: 1 !important; }
  .justify-content-md-start { justify-content: flex-start !important; }
  .justify-content-md-end { justify-content: flex-end !important; }
  .justify-content-md-center { justify-content: center !important; }
  .justify-content-md-between { justify-content: space-between !important; }
  .justify-content-md-around { justify-content: space-around !important; }
  .align-items-md-start { align-items: flex-start !important; }
  .align-items-md-end { align-items: flex-end !important; }
  .align-items-md-center { align-items: center !important; }
  .align-items-md-baseline { align-items: baseline !important; }
  .align-items-md-stretch { align-items: stretch !important; }
  .align-content-md-start { align-content: flex-start !important; }
  .align-content-md-end { align-content: flex-end !important; }
  .align-content-md-center { align-content: center !important; }
  .align-content-md-between { align-content: space-between !important; }
  .align-content-md-around { align-content: space-around !important; }
  .align-content-md-stretch { align-content: stretch !important; }
  .align-self-md-auto { align-self: auto !important; }
  .align-self-md-start { align-self: flex-start !important; }
  .align-self-md-end { align-self: flex-end !important; }
  .align-self-md-center { align-self: center !important; }
  .align-self-md-baseline { align-self: baseline !important; }
  .align-self-md-stretch { align-self: stretch !important; } }

@media (min-width: 992px) { .flex-lg-row { flex-direction: row !important; }
  .flex-lg-column { flex-direction: column !important; }
  .flex-lg-row-reverse { flex-direction: row-reverse !important; }
  .flex-lg-column-reverse { flex-direction: column-reverse !important; }
  .flex-lg-wrap { flex-wrap: wrap !important; }
  .flex-lg-nowrap { flex-wrap: nowrap !important; }
  .flex-lg-wrap-reverse { flex-wrap: wrap-reverse !important; }
  .flex-lg-fill { flex: 1 1 auto !important; }
  .flex-lg-grow-0 { flex-grow: 0 !important; }
  .flex-lg-grow-1 { flex-grow: 1 !important; }
  .flex-lg-shrink-0 { flex-shrink: 0 !important; }
  .flex-lg-shrink-1 { flex-shrink: 1 !important; }
  .justify-content-lg-start { justify-content: flex-start !important; }
  .justify-content-lg-end { justify-content: flex-end !important; }
  .justify-content-lg-center { justify-content: center !important; }
  .justify-content-lg-between { justify-content: space-between !important; }
  .justify-content-lg-around { justify-content: space-around !important; }
  .align-items-lg-start { align-items: flex-start !important; }
  .align-items-lg-end { align-items: flex-end !important; }
  .align-items-lg-center { align-items: center !important; }
  .align-items-lg-baseline { align-items: baseline !important; }
  .align-items-lg-stretch { align-items: stretch !important; }
  .align-content-lg-start { align-content: flex-start !important; }
  .align-content-lg-end { align-content: flex-end !important; }
  .align-content-lg-center { align-content: center !important; }
  .align-content-lg-between { align-content: space-between !important; }
  .align-content-lg-around { align-content: space-around !important; }
  .align-content-lg-stretch { align-content: stretch !important; }
  .align-self-lg-auto { align-self: auto !important; }
  .align-self-lg-start { align-self: flex-start !important; }
  .align-self-lg-end { align-self: flex-end !important; }
  .align-self-lg-center { align-self: center !important; }
  .align-self-lg-baseline { align-self: baseline !important; }
  .align-self-lg-stretch { align-self: stretch !important; } }

@media (min-width: 1200px) { .flex-xl-row { flex-direction: row !important; }
  .flex-xl-column { flex-direction: column !important; }
  .flex-xl-row-reverse { flex-direction: row-reverse !important; }
  .flex-xl-column-reverse { flex-direction: column-reverse !important; }
  .flex-xl-wrap { flex-wrap: wrap !important; }
  .flex-xl-nowrap { flex-wrap: nowrap !important; }
  .flex-xl-wrap-reverse { flex-wrap: wrap-reverse !important; }
  .flex-xl-fill { flex: 1 1 auto !important; }
  .flex-xl-grow-0 { flex-grow: 0 !important; }
  .flex-xl-grow-1 { flex-grow: 1 !important; }
  .flex-xl-shrink-0 { flex-shrink: 0 !important; }
  .flex-xl-shrink-1 { flex-shrink: 1 !important; }
  .justify-content-xl-start { justify-content: flex-start !important; }
  .justify-content-xl-end { justify-content: flex-end !important; }
  .justify-content-xl-center { justify-content: center !important; }
  .justify-content-xl-between { justify-content: space-between !important; }
  .justify-content-xl-around { justify-content: space-around !important; }
  .align-items-xl-start { align-items: flex-start !important; }
  .align-items-xl-end { align-items: flex-end !important; }
  .align-items-xl-center { align-items: center !important; }
  .align-items-xl-baseline { align-items: baseline !important; }
  .align-items-xl-stretch { align-items: stretch !important; }
  .align-content-xl-start { align-content: flex-start !important; }
  .align-content-xl-end { align-content: flex-end !important; }
  .align-content-xl-center { align-content: center !important; }
  .align-content-xl-between { align-content: space-between !important; }
  .align-content-xl-around { align-content: space-around !important; }
  .align-content-xl-stretch { align-content: stretch !important; }
  .align-self-xl-auto { align-self: auto !important; }
  .align-self-xl-start { align-self: flex-start !important; }
  .align-self-xl-end { align-self: flex-end !important; }
  .align-self-xl-center { align-self: center !important; }
  .align-self-xl-baseline { align-self: baseline !important; }
  .align-self-xl-stretch { align-self: stretch !important; } }

@media (min-width: 1540px) { .flex-xxl-row { flex-direction: row !important; }
  .flex-xxl-column { flex-direction: column !important; }
  .flex-xxl-row-reverse { flex-direction: row-reverse !important; }
  .flex-xxl-column-reverse { flex-direction: column-reverse !important; }
  .flex-xxl-wrap { flex-wrap: wrap !important; }
  .flex-xxl-nowrap { flex-wrap: nowrap !important; }
  .flex-xxl-wrap-reverse { flex-wrap: wrap-reverse !important; }
  .flex-xxl-fill { flex: 1 1 auto !important; }
  .flex-xxl-grow-0 { flex-grow: 0 !important; }
  .flex-xxl-grow-1 { flex-grow: 1 !important; }
  .flex-xxl-shrink-0 { flex-shrink: 0 !important; }
  .flex-xxl-shrink-1 { flex-shrink: 1 !important; }
  .justify-content-xxl-start { justify-content: flex-start !important; }
  .justify-content-xxl-end { justify-content: flex-end !important; }
  .justify-content-xxl-center { justify-content: center !important; }
  .justify-content-xxl-between { justify-content: space-between !important; }
  .justify-content-xxl-around { justify-content: space-around !important; }
  .align-items-xxl-start { align-items: flex-start !important; }
  .align-items-xxl-end { align-items: flex-end !important; }
  .align-items-xxl-center { align-items: center !important; }
  .align-items-xxl-baseline { align-items: baseline !important; }
  .align-items-xxl-stretch { align-items: stretch !important; }
  .align-content-xxl-start { align-content: flex-start !important; }
  .align-content-xxl-end { align-content: flex-end !important; }
  .align-content-xxl-center { align-content: center !important; }
  .align-content-xxl-between { align-content: space-between !important; }
  .align-content-xxl-around { align-content: space-around !important; }
  .align-content-xxl-stretch { align-content: stretch !important; }
  .align-self-xxl-auto { align-self: auto !important; }
  .align-self-xxl-start { align-self: flex-start !important; }
  .align-self-xxl-end { align-self: flex-end !important; }
  .align-self-xxl-center { align-self: center !important; }
  .align-self-xxl-baseline { align-self: baseline !important; }
  .align-self-xxl-stretch { align-self: stretch !important; } }

.float-left { float: left !important; }

.float-right { float: right !important; }

.float-none { float: none !important; }

@media (min-width: 576px) { .float-sm-left { float: left !important; }
  .float-sm-right { float: right !important; }
  .float-sm-none { float: none !important; } }

@media (min-width: 768px) { .float-md-left { float: left !important; }
  .float-md-right { float: right !important; }
  .float-md-none { float: none !important; } }

@media (min-width: 992px) { .float-lg-left { float: left !important; }
  .float-lg-right { float: right !important; }
  .float-lg-none { float: none !important; } }

@media (min-width: 1200px) { .float-xl-left { float: left !important; }
  .float-xl-right { float: right !important; }
  .float-xl-none { float: none !important; } }

@media (min-width: 1540px) { .float-xxl-left { float: left !important; }
  .float-xxl-right { float: right !important; }
  .float-xxl-none { float: none !important; } }

.user-select-all { user-select: all !important; }

.user-select-auto { user-select: auto !important; }

.user-select-none { user-select: none !important; }

.overflow-auto { overflow: auto !important; }

.overflow-hidden { overflow: hidden !important; }

.position-static { position: static !important; }

.position-relative, .pos-rel { position: relative !important; }

.position-absolute, .pos-abs { position: absolute !important; }

.position-fixed { position: fixed !important; }

.position-sticky { position: sticky !important; }

.fixed-top { position: fixed; top: 0; right: 0; left: 0; z-index: 1030; }

.fixed-bottom { position: fixed; right: 0; bottom: 0; left: 0; z-index: 1030; }

@supports (position: sticky) { .sticky-top { position: sticky; top: 0; z-index: 1020; } }

.sr-only { position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0, 0, 0, 0); white-space: nowrap; border: 0; }

.sr-only-focusable:active, .sr-only-focusable:focus { position: static; width: auto; height: auto; overflow: visible; clip: auto; white-space: normal; }

.shadow-sm { box-shadow: 0 0.125rem 0.25rem rgba(43, 55, 72, 0.15) !important; }

.shadow { box-shadow: 0 3px 12px 1px rgba(43, 55, 72, 0.15) !important; }

.shadow-lg { box-shadow: 0 1rem 3rem rgba(43, 55, 72, 0.25) !important; }

.shadow-none { box-shadow: none !important; }

.w-25 { width: 25% !important; }

.w-50 { width: 50% !important; }

.w-75 { width: 75% !important; }

.w-100 { width: 100% !important; }

.w-auto { width: auto !important; }

.h-25 { height: 25% !important; }

.h-50 { height: 50% !important; }

.h-75 { height: 75% !important; }

.h-100 { height: 100% !important; }

.h-auto { height: auto !important; }

.mw-100 { max-width: 100% !important; }

.mh-100 { max-height: 100% !important; }

.min-vw-100 { min-width: 100vw !important; }

.min-vh-100 { min-height: 100vh !important; }

.vw-100 { width: 100vw !important; }

.vh-100 { height: 100vh !important; }

.m-0 { margin: 0 !important; }

.mt-0, .my-0 { margin-top: 0 !important; }

.mr-0, .mx-0 { margin-right: 0 !important; }

.mb-0, .my-0 { margin-bottom: 0 !important; }

.ml-0, .mx-0 { margin-left: 0 !important; }

.m-1 { margin: 0.375rem !important; }

.mt-1, .my-1 { margin-top: 0.375rem !important; }

.mr-1, .mx-1 { margin-right: 0.375rem !important; }

.mb-1, .my-1 { margin-bottom: 0.375rem !important; }

.ml-1, .mx-1 { margin-left: 0.375rem !important; }

.m-2 { margin: 0.75rem !important; }

.mt-2, .my-2 { margin-top: 0.75rem !important; }

.mr-2, .mx-2 { margin-right: 0.75rem !important; }

.mb-2, .my-2 { margin-bottom: 0.75rem !important; }

.ml-2, .mx-2 { margin-left: 0.75rem !important; }

.m-3 { margin: 1rem !important; }

.mt-3, .my-3 { margin-top: 1rem !important; }

.mr-3, .mx-3 { margin-right: 1rem !important; }

.mb-3, .my-3 { margin-bottom: 1rem !important; }

.ml-3, .mx-3 { margin-left: 1rem !important; }

.m-4 { margin: 1.5rem !important; }

.mt-4, .my-4 { margin-top: 1.5rem !important; }

.mr-4, .mx-4 { margin-right: 1.5rem !important; }

.mb-4, .my-4 { margin-bottom: 1.5rem !important; }

.ml-4, .mx-4 { margin-left: 1.5rem !important; }

.m-5 { margin: 2.75rem !important; }

.mt-5, .my-5 { margin-top: 2.75rem !important; }

.mr-5, .mx-5 { margin-right: 2.75rem !important; }

.mb-5, .my-5 { margin-bottom: 2.75rem !important; }

.ml-5, .mx-5 { margin-left: 2.75rem !important; }

.m-gs { margin: 28px !important; }

.mt-gs, .my-gs { margin-top: 28px !important; }

.mr-gs, .mx-gs { margin-right: 28px !important; }

.mb-gs, .my-gs { margin-bottom: 28px !important; }

.ml-gs, .mx-gs { margin-left: 28px !important; }

.p-0 { padding: 0 !important; }

.pt-0, .py-0 { padding-top: 0 !important; }

.pr-0, .px-0 { padding-right: 0 !important; }

.pb-0, .py-0 { padding-bottom: 0 !important; }

.pl-0, .px-0 { padding-left: 0 !important; }

.p-1 { padding: 0.375rem !important; }

.pt-1, .py-1 { padding-top: 0.375rem !important; }

.pr-1, .px-1 { padding-right: 0.375rem !important; }

.pb-1, .py-1 { padding-bottom: 0.375rem !important; }

.pl-1, .px-1 { padding-left: 0.375rem !important; }

.p-2 { padding: 0.75rem !important; }

.pt-2, .py-2 { padding-top: 0.75rem !important; }

.pr-2, .px-2 { padding-right: 0.75rem !important; }

.pb-2, .py-2 { padding-bottom: 0.75rem !important; }

.pl-2, .px-2 { padding-left: 0.75rem !important; }

.p-3 { padding: 1rem !important; }

.pt-3, .py-3 { padding-top: 1rem !important; }

.pr-3, .px-3 { padding-right: 1rem !important; }

.pb-3, .py-3 { padding-bottom: 1rem !important; }

.pl-3, .px-3 { padding-left: 1rem !important; }

.p-4 { padding: 1.5rem !important; }

.pt-4, .py-4 { padding-top: 1.5rem !important; }

.pr-4, .px-4 { padding-right: 1.5rem !important; }

.pb-4, .py-4 { padding-bottom: 1.5rem !important; }

.pl-4, .px-4 { padding-left: 1.5rem !important; }

.p-5 { padding: 2.75rem !important; }

.pt-5, .py-5 { padding-top: 2.75rem !important; }

.pr-5, .px-5 { padding-right: 2.75rem !important; }

.pb-5, .py-5 { padding-bottom: 2.75rem !important; }

.pl-5, .px-5 { padding-left: 2.75rem !important; }

.p-gs { padding: 28px !important; }

.pt-gs, .py-gs { padding-top: 28px !important; }

.pr-gs, .px-gs { padding-right: 28px !important; }

.pb-gs, .py-gs { padding-bottom: 28px !important; }

.pl-gs, .px-gs { padding-left: 28px !important; }

.m-n1 { margin: -0.375rem !important; }

.mt-n1, .my-n1 { margin-top: -0.375rem !important; }

.mr-n1, .mx-n1 { margin-right: -0.375rem !important; }

.mb-n1, .my-n1 { margin-bottom: -0.375rem !important; }

.ml-n1, .mx-n1 { margin-left: -0.375rem !important; }

.m-n2 { margin: -0.75rem !important; }

.mt-n2, .my-n2 { margin-top: -0.75rem !important; }

.mr-n2, .mx-n2 { margin-right: -0.75rem !important; }

.mb-n2, .my-n2 { margin-bottom: -0.75rem !important; }

.ml-n2, .mx-n2 { margin-left: -0.75rem !important; }

.m-n3 { margin: -1rem !important; }

.mt-n3, .my-n3 { margin-top: -1rem !important; }

.mr-n3, .mx-n3 { margin-right: -1rem !important; }

.mb-n3, .my-n3 { margin-bottom: -1rem !important; }

.ml-n3, .mx-n3 { margin-left: -1rem !important; }

.m-n4 { margin: -1.5rem !important; }

.mt-n4, .my-n4 { margin-top: -1.5rem !important; }

.mr-n4, .mx-n4 { margin-right: -1.5rem !important; }

.mb-n4, .my-n4 { margin-bottom: -1.5rem !important; }

.ml-n4, .mx-n4 { margin-left: -1.5rem !important; }

.m-n5 { margin: -2.75rem !important; }

.mt-n5, .my-n5 { margin-top: -2.75rem !important; }

.mr-n5, .mx-n5 { margin-right: -2.75rem !important; }

.mb-n5, .my-n5 { margin-bottom: -2.75rem !important; }

.ml-n5, .mx-n5 { margin-left: -2.75rem !important; }

.m-ngs { margin: -28px !important; }

.mt-ngs, .my-ngs { margin-top: -28px !important; }

.mr-ngs, .mx-ngs { margin-right: -28px !important; }

.mb-ngs, .my-ngs { margin-bottom: -28px !important; }

.ml-ngs, .mx-ngs { margin-left: -28px !important; }

.m-auto { margin: auto !important; }

.mt-auto, .my-auto { margin-top: auto !important; }

.mr-auto, .mx-auto { margin-right: auto !important; }

.mb-auto, .my-auto { margin-bottom: auto !important; }

.ml-auto, .mx-auto { margin-left: auto !important; }

@media (min-width: 576px) { .m-sm-0 { margin: 0 !important; }
  .mt-sm-0, .my-sm-0 { margin-top: 0 !important; }
  .mr-sm-0, .mx-sm-0 { margin-right: 0 !important; }
  .mb-sm-0, .my-sm-0 { margin-bottom: 0 !important; }
  .ml-sm-0, .mx-sm-0 { margin-left: 0 !important; }
  .m-sm-1 { margin: 0.375rem !important; }
  .mt-sm-1, .my-sm-1 { margin-top: 0.375rem !important; }
  .mr-sm-1, .mx-sm-1 { margin-right: 0.375rem !important; }
  .mb-sm-1, .my-sm-1 { margin-bottom: 0.375rem !important; }
  .ml-sm-1, .mx-sm-1 { margin-left: 0.375rem !important; }
  .m-sm-2 { margin: 0.75rem !important; }
  .mt-sm-2, .my-sm-2 { margin-top: 0.75rem !important; }
  .mr-sm-2, .mx-sm-2 { margin-right: 0.75rem !important; }
  .mb-sm-2, .my-sm-2 { margin-bottom: 0.75rem !important; }
  .ml-sm-2, .mx-sm-2 { margin-left: 0.75rem !important; }
  .m-sm-3 { margin: 1rem !important; }
  .mt-sm-3, .my-sm-3 { margin-top: 1rem !important; }
  .mr-sm-3, .mx-sm-3 { margin-right: 1rem !important; }
  .mb-sm-3, .my-sm-3 { margin-bottom: 1rem !important; }
  .ml-sm-3, .mx-sm-3 { margin-left: 1rem !important; }
  .m-sm-4 { margin: 1.5rem !important; }
  .mt-sm-4, .my-sm-4 { margin-top: 1.5rem !important; }
  .mr-sm-4, .mx-sm-4 { margin-right: 1.5rem !important; }
  .mb-sm-4, .my-sm-4 { margin-bottom: 1.5rem !important; }
  .ml-sm-4, .mx-sm-4 { margin-left: 1.5rem !important; }
  .m-sm-5 { margin: 2.75rem !important; }
  .mt-sm-5, .my-sm-5 { margin-top: 2.75rem !important; }
  .mr-sm-5, .mx-sm-5 { margin-right: 2.75rem !important; }
  .mb-sm-5, .my-sm-5 { margin-bottom: 2.75rem !important; }
  .ml-sm-5, .mx-sm-5 { margin-left: 2.75rem !important; }
  .m-sm-gs { margin: 28px !important; }
  .mt-sm-gs, .my-sm-gs { margin-top: 28px !important; }
  .mr-sm-gs, .mx-sm-gs { margin-right: 28px !important; }
  .mb-sm-gs, .my-sm-gs { margin-bottom: 28px !important; }
  .ml-sm-gs, .mx-sm-gs { margin-left: 28px !important; }
  .p-sm-0 { padding: 0 !important; }
  .pt-sm-0, .py-sm-0 { padding-top: 0 !important; }
  .pr-sm-0, .px-sm-0 { padding-right: 0 !important; }
  .pb-sm-0, .py-sm-0 { padding-bottom: 0 !important; }
  .pl-sm-0, .px-sm-0 { padding-left: 0 !important; }
  .p-sm-1 { padding: 0.375rem !important; }
  .pt-sm-1, .py-sm-1 { padding-top: 0.375rem !important; }
  .pr-sm-1, .px-sm-1 { padding-right: 0.375rem !important; }
  .pb-sm-1, .py-sm-1 { padding-bottom: 0.375rem !important; }
  .pl-sm-1, .px-sm-1 { padding-left: 0.375rem !important; }
  .p-sm-2 { padding: 0.75rem !important; }
  .pt-sm-2, .py-sm-2 { padding-top: 0.75rem !important; }
  .pr-sm-2, .px-sm-2 { padding-right: 0.75rem !important; }
  .pb-sm-2, .py-sm-2 { padding-bottom: 0.75rem !important; }
  .pl-sm-2, .px-sm-2 { padding-left: 0.75rem !important; }
  .p-sm-3 { padding: 1rem !important; }
  .pt-sm-3, .py-sm-3 { padding-top: 1rem !important; }
  .pr-sm-3, .px-sm-3 { padding-right: 1rem !important; }
  .pb-sm-3, .py-sm-3 { padding-bottom: 1rem !important; }
  .pl-sm-3, .px-sm-3 { padding-left: 1rem !important; }
  .p-sm-4 { padding: 1.5rem !important; }
  .pt-sm-4, .py-sm-4 { padding-top: 1.5rem !important; }
  .pr-sm-4, .px-sm-4 { padding-right: 1.5rem !important; }
  .pb-sm-4, .py-sm-4 { padding-bottom: 1.5rem !important; }
  .pl-sm-4, .px-sm-4 { padding-left: 1.5rem !important; }
  .p-sm-5 { padding: 2.75rem !important; }
  .pt-sm-5, .py-sm-5 { padding-top: 2.75rem !important; }
  .pr-sm-5, .px-sm-5 { padding-right: 2.75rem !important; }
  .pb-sm-5, .py-sm-5 { padding-bottom: 2.75rem !important; }
  .pl-sm-5, .px-sm-5 { padding-left: 2.75rem !important; }
  .p-sm-gs { padding: 28px !important; }
  .pt-sm-gs, .py-sm-gs { padding-top: 28px !important; }
  .pr-sm-gs, .px-sm-gs { padding-right: 28px !important; }
  .pb-sm-gs, .py-sm-gs { padding-bottom: 28px !important; }
  .pl-sm-gs, .px-sm-gs { padding-left: 28px !important; }
  .m-sm-n1 { margin: -0.375rem !important; }
  .mt-sm-n1, .my-sm-n1 { margin-top: -0.375rem !important; }
  .mr-sm-n1, .mx-sm-n1 { margin-right: -0.375rem !important; }
  .mb-sm-n1, .my-sm-n1 { margin-bottom: -0.375rem !important; }
  .ml-sm-n1, .mx-sm-n1 { margin-left: -0.375rem !important; }
  .m-sm-n2 { margin: -0.75rem !important; }
  .mt-sm-n2, .my-sm-n2 { margin-top: -0.75rem !important; }
  .mr-sm-n2, .mx-sm-n2 { margin-right: -0.75rem !important; }
  .mb-sm-n2, .my-sm-n2 { margin-bottom: -0.75rem !important; }
  .ml-sm-n2, .mx-sm-n2 { margin-left: -0.75rem !important; }
  .m-sm-n3 { margin: -1rem !important; }
  .mt-sm-n3, .my-sm-n3 { margin-top: -1rem !important; }
  .mr-sm-n3, .mx-sm-n3 { margin-right: -1rem !important; }
  .mb-sm-n3, .my-sm-n3 { margin-bottom: -1rem !important; }
  .ml-sm-n3, .mx-sm-n3 { margin-left: -1rem !important; }
  .m-sm-n4 { margin: -1.5rem !important; }
  .mt-sm-n4, .my-sm-n4 { margin-top: -1.5rem !important; }
  .mr-sm-n4, .mx-sm-n4 { margin-right: -1.5rem !important; }
  .mb-sm-n4, .my-sm-n4 { margin-bottom: -1.5rem !important; }
  .ml-sm-n4, .mx-sm-n4 { margin-left: -1.5rem !important; }
  .m-sm-n5 { margin: -2.75rem !important; }
  .mt-sm-n5, .my-sm-n5 { margin-top: -2.75rem !important; }
  .mr-sm-n5, .mx-sm-n5 { margin-right: -2.75rem !important; }
  .mb-sm-n5, .my-sm-n5 { margin-bottom: -2.75rem !important; }
  .ml-sm-n5, .mx-sm-n5 { margin-left: -2.75rem !important; }
  .m-sm-ngs { margin: -28px !important; }
  .mt-sm-ngs, .my-sm-ngs { margin-top: -28px !important; }
  .mr-sm-ngs, .mx-sm-ngs { margin-right: -28px !important; }
  .mb-sm-ngs, .my-sm-ngs { margin-bottom: -28px !important; }
  .ml-sm-ngs, .mx-sm-ngs { margin-left: -28px !important; }
  .m-sm-auto { margin: auto !important; }
  .mt-sm-auto, .my-sm-auto { margin-top: auto !important; }
  .mr-sm-auto, .mx-sm-auto { margin-right: auto !important; }
  .mb-sm-auto, .my-sm-auto { margin-bottom: auto !important; }
  .ml-sm-auto, .mx-sm-auto { margin-left: auto !important; } }

@media (min-width: 768px) { .m-md-0 { margin: 0 !important; }
  .mt-md-0, .my-md-0 { margin-top: 0 !important; }
  .mr-md-0, .mx-md-0 { margin-right: 0 !important; }
  .mb-md-0, .my-md-0 { margin-bottom: 0 !important; }
  .ml-md-0, .mx-md-0 { margin-left: 0 !important; }
  .m-md-1 { margin: 0.375rem !important; }
  .mt-md-1, .my-md-1 { margin-top: 0.375rem !important; }
  .mr-md-1, .mx-md-1 { margin-right: 0.375rem !important; }
  .mb-md-1, .my-md-1 { margin-bottom: 0.375rem !important; }
  .ml-md-1, .mx-md-1 { margin-left: 0.375rem !important; }
  .m-md-2 { margin: 0.75rem !important; }
  .mt-md-2, .my-md-2 { margin-top: 0.75rem !important; }
  .mr-md-2, .mx-md-2 { margin-right: 0.75rem !important; }
  .mb-md-2, .my-md-2 { margin-bottom: 0.75rem !important; }
  .ml-md-2, .mx-md-2 { margin-left: 0.75rem !important; }
  .m-md-3 { margin: 1rem !important; }
  .mt-md-3, .my-md-3 { margin-top: 1rem !important; }
  .mr-md-3, .mx-md-3 { margin-right: 1rem !important; }
  .mb-md-3, .my-md-3 { margin-bottom: 1rem !important; }
  .ml-md-3, .mx-md-3 { margin-left: 1rem !important; }
  .m-md-4 { margin: 1.5rem !important; }
  .mt-md-4, .my-md-4 { margin-top: 1.5rem !important; }
  .mr-md-4, .mx-md-4 { margin-right: 1.5rem !important; }
  .mb-md-4, .my-md-4 { margin-bottom: 1.5rem !important; }
  .ml-md-4, .mx-md-4 { margin-left: 1.5rem !important; }
  .m-md-5 { margin: 2.75rem !important; }
  .mt-md-5, .my-md-5 { margin-top: 2.75rem !important; }
  .mr-md-5, .mx-md-5 { margin-right: 2.75rem !important; }
  .mb-md-5, .my-md-5 { margin-bottom: 2.75rem !important; }
  .ml-md-5, .mx-md-5 { margin-left: 2.75rem !important; }
  .m-md-gs { margin: 28px !important; }
  .mt-md-gs, .my-md-gs { margin-top: 28px !important; }
  .mr-md-gs, .mx-md-gs { margin-right: 28px !important; }
  .mb-md-gs, .my-md-gs { margin-bottom: 28px !important; }
  .ml-md-gs, .mx-md-gs { margin-left: 28px !important; }
  .p-md-0 { padding: 0 !important; }
  .pt-md-0, .py-md-0 { padding-top: 0 !important; }
  .pr-md-0, .px-md-0 { padding-right: 0 !important; }
  .pb-md-0, .py-md-0 { padding-bottom: 0 !important; }
  .pl-md-0, .px-md-0 { padding-left: 0 !important; }
  .p-md-1 { padding: 0.375rem !important; }
  .pt-md-1, .py-md-1 { padding-top: 0.375rem !important; }
  .pr-md-1, .px-md-1 { padding-right: 0.375rem !important; }
  .pb-md-1, .py-md-1 { padding-bottom: 0.375rem !important; }
  .pl-md-1, .px-md-1 { padding-left: 0.375rem !important; }
  .p-md-2 { padding: 0.75rem !important; }
  .pt-md-2, .py-md-2 { padding-top: 0.75rem !important; }
  .pr-md-2, .px-md-2 { padding-right: 0.75rem !important; }
  .pb-md-2, .py-md-2 { padding-bottom: 0.75rem !important; }
  .pl-md-2, .px-md-2 { padding-left: 0.75rem !important; }
  .p-md-3 { padding: 1rem !important; }
  .pt-md-3, .py-md-3 { padding-top: 1rem !important; }
  .pr-md-3, .px-md-3 { padding-right: 1rem !important; }
  .pb-md-3, .py-md-3 { padding-bottom: 1rem !important; }
  .pl-md-3, .px-md-3 { padding-left: 1rem !important; }
  .p-md-4 { padding: 1.5rem !important; }
  .pt-md-4, .py-md-4 { padding-top: 1.5rem !important; }
  .pr-md-4, .px-md-4 { padding-right: 1.5rem !important; }
  .pb-md-4, .py-md-4 { padding-bottom: 1.5rem !important; }
  .pl-md-4, .px-md-4 { padding-left: 1.5rem !important; }
  .p-md-5 { padding: 2.75rem !important; }
  .pt-md-5, .py-md-5 { padding-top: 2.75rem !important; }
  .pr-md-5, .px-md-5 { padding-right: 2.75rem !important; }
  .pb-md-5, .py-md-5 { padding-bottom: 2.75rem !important; }
  .pl-md-5, .px-md-5 { padding-left: 2.75rem !important; }
  .p-md-gs { padding: 28px !important; }
  .pt-md-gs, .py-md-gs { padding-top: 28px !important; }
  .pr-md-gs, .px-md-gs { padding-right: 28px !important; }
  .pb-md-gs, .py-md-gs { padding-bottom: 28px !important; }
  .pl-md-gs, .px-md-gs { padding-left: 28px !important; }
  .m-md-n1 { margin: -0.375rem !important; }
  .mt-md-n1, .my-md-n1 { margin-top: -0.375rem !important; }
  .mr-md-n1, .mx-md-n1 { margin-right: -0.375rem !important; }
  .mb-md-n1, .my-md-n1 { margin-bottom: -0.375rem !important; }
  .ml-md-n1, .mx-md-n1 { margin-left: -0.375rem !important; }
  .m-md-n2 { margin: -0.75rem !important; }
  .mt-md-n2, .my-md-n2 { margin-top: -0.75rem !important; }
  .mr-md-n2, .mx-md-n2 { margin-right: -0.75rem !important; }
  .mb-md-n2, .my-md-n2 { margin-bottom: -0.75rem !important; }
  .ml-md-n2, .mx-md-n2 { margin-left: -0.75rem !important; }
  .m-md-n3 { margin: -1rem !important; }
  .mt-md-n3, .my-md-n3 { margin-top: -1rem !important; }
  .mr-md-n3, .mx-md-n3 { margin-right: -1rem !important; }
  .mb-md-n3, .my-md-n3 { margin-bottom: -1rem !important; }
  .ml-md-n3, .mx-md-n3 { margin-left: -1rem !important; }
  .m-md-n4 { margin: -1.5rem !important; }
  .mt-md-n4, .my-md-n4 { margin-top: -1.5rem !important; }
  .mr-md-n4, .mx-md-n4 { margin-right: -1.5rem !important; }
  .mb-md-n4, .my-md-n4 { margin-bottom: -1.5rem !important; }
  .ml-md-n4, .mx-md-n4 { margin-left: -1.5rem !important; }
  .m-md-n5 { margin: -2.75rem !important; }
  .mt-md-n5, .my-md-n5 { margin-top: -2.75rem !important; }
  .mr-md-n5, .mx-md-n5 { margin-right: -2.75rem !important; }
  .mb-md-n5, .my-md-n5 { margin-bottom: -2.75rem !important; }
  .ml-md-n5, .mx-md-n5 { margin-left: -2.75rem !important; }
  .m-md-ngs { margin: -28px !important; }
  .mt-md-ngs, .my-md-ngs { margin-top: -28px !important; }
  .mr-md-ngs, .mx-md-ngs { margin-right: -28px !important; }
  .mb-md-ngs, .my-md-ngs { margin-bottom: -28px !important; }
  .ml-md-ngs, .mx-md-ngs { margin-left: -28px !important; }
  .m-md-auto { margin: auto !important; }
  .mt-md-auto, .my-md-auto { margin-top: auto !important; }
  .mr-md-auto, .mx-md-auto { margin-right: auto !important; }
  .mb-md-auto, .my-md-auto { margin-bottom: auto !important; }
  .ml-md-auto, .mx-md-auto { margin-left: auto !important; } }

@media (min-width: 992px) { .m-lg-0 { margin: 0 !important; }
  .mt-lg-0, .my-lg-0 { margin-top: 0 !important; }
  .mr-lg-0, .mx-lg-0 { margin-right: 0 !important; }
  .mb-lg-0, .my-lg-0 { margin-bottom: 0 !important; }
  .ml-lg-0, .mx-lg-0 { margin-left: 0 !important; }
  .m-lg-1 { margin: 0.375rem !important; }
  .mt-lg-1, .my-lg-1 { margin-top: 0.375rem !important; }
  .mr-lg-1, .mx-lg-1 { margin-right: 0.375rem !important; }
  .mb-lg-1, .my-lg-1 { margin-bottom: 0.375rem !important; }
  .ml-lg-1, .mx-lg-1 { margin-left: 0.375rem !important; }
  .m-lg-2 { margin: 0.75rem !important; }
  .mt-lg-2, .my-lg-2 { margin-top: 0.75rem !important; }
  .mr-lg-2, .mx-lg-2 { margin-right: 0.75rem !important; }
  .mb-lg-2, .my-lg-2 { margin-bottom: 0.75rem !important; }
  .ml-lg-2, .mx-lg-2 { margin-left: 0.75rem !important; }
  .m-lg-3 { margin: 1rem !important; }
  .mt-lg-3, .my-lg-3 { margin-top: 1rem !important; }
  .mr-lg-3, .mx-lg-3 { margin-right: 1rem !important; }
  .mb-lg-3, .my-lg-3 { margin-bottom: 1rem !important; }
  .ml-lg-3, .mx-lg-3 { margin-left: 1rem !important; }
  .m-lg-4 { margin: 1.5rem !important; }
  .mt-lg-4, .my-lg-4 { margin-top: 1.5rem !important; }
  .mr-lg-4, .mx-lg-4 { margin-right: 1.5rem !important; }
  .mb-lg-4, .my-lg-4 { margin-bottom: 1.5rem !important; }
  .ml-lg-4, .mx-lg-4 { margin-left: 1.5rem !important; }
  .m-lg-5 { margin: 2.75rem !important; }
  .mt-lg-5, .my-lg-5 { margin-top: 2.75rem !important; }
  .mr-lg-5, .mx-lg-5 { margin-right: 2.75rem !important; }
  .mb-lg-5, .my-lg-5 { margin-bottom: 2.75rem !important; }
  .ml-lg-5, .mx-lg-5 { margin-left: 2.75rem !important; }
  .m-lg-gs { margin: 28px !important; }
  .mt-lg-gs, .my-lg-gs { margin-top: 28px !important; }
  .mr-lg-gs, .mx-lg-gs { margin-right: 28px !important; }
  .mb-lg-gs, .my-lg-gs { margin-bottom: 28px !important; }
  .ml-lg-gs, .mx-lg-gs { margin-left: 28px !important; }
  .p-lg-0 { padding: 0 !important; }
  .pt-lg-0, .py-lg-0 { padding-top: 0 !important; }
  .pr-lg-0, .px-lg-0 { padding-right: 0 !important; }
  .pb-lg-0, .py-lg-0 { padding-bottom: 0 !important; }
  .pl-lg-0, .px-lg-0 { padding-left: 0 !important; }
  .p-lg-1 { padding: 0.375rem !important; }
  .pt-lg-1, .py-lg-1 { padding-top: 0.375rem !important; }
  .pr-lg-1, .px-lg-1 { padding-right: 0.375rem !important; }
  .pb-lg-1, .py-lg-1 { padding-bottom: 0.375rem !important; }
  .pl-lg-1, .px-lg-1 { padding-left: 0.375rem !important; }
  .p-lg-2 { padding: 0.75rem !important; }
  .pt-lg-2, .py-lg-2 { padding-top: 0.75rem !important; }
  .pr-lg-2, .px-lg-2 { padding-right: 0.75rem !important; }
  .pb-lg-2, .py-lg-2 { padding-bottom: 0.75rem !important; }
  .pl-lg-2, .px-lg-2 { padding-left: 0.75rem !important; }
  .p-lg-3 { padding: 1rem !important; }
  .pt-lg-3, .py-lg-3 { padding-top: 1rem !important; }
  .pr-lg-3, .px-lg-3 { padding-right: 1rem !important; }
  .pb-lg-3, .py-lg-3 { padding-bottom: 1rem !important; }
  .pl-lg-3, .px-lg-3 { padding-left: 1rem !important; }
  .p-lg-4 { padding: 1.5rem !important; }
  .pt-lg-4, .py-lg-4 { padding-top: 1.5rem !important; }
  .pr-lg-4, .px-lg-4 { padding-right: 1.5rem !important; }
  .pb-lg-4, .py-lg-4 { padding-bottom: 1.5rem !important; }
  .pl-lg-4, .px-lg-4 { padding-left: 1.5rem !important; }
  .p-lg-5 { padding: 2.75rem !important; }
  .pt-lg-5, .py-lg-5 { padding-top: 2.75rem !important; }
  .pr-lg-5, .px-lg-5 { padding-right: 2.75rem !important; }
  .pb-lg-5, .py-lg-5 { padding-bottom: 2.75rem !important; }
  .pl-lg-5, .px-lg-5 { padding-left: 2.75rem !important; }
  .p-lg-gs { padding: 28px !important; }
  .pt-lg-gs, .py-lg-gs { padding-top: 28px !important; }
  .pr-lg-gs, .px-lg-gs { padding-right: 28px !important; }
  .pb-lg-gs, .py-lg-gs { padding-bottom: 28px !important; }
  .pl-lg-gs, .px-lg-gs { padding-left: 28px !important; }
  .m-lg-n1 { margin: -0.375rem !important; }
  .mt-lg-n1, .my-lg-n1 { margin-top: -0.375rem !important; }
  .mr-lg-n1, .mx-lg-n1 { margin-right: -0.375rem !important; }
  .mb-lg-n1, .my-lg-n1 { margin-bottom: -0.375rem !important; }
  .ml-lg-n1, .mx-lg-n1 { margin-left: -0.375rem !important; }
  .m-lg-n2 { margin: -0.75rem !important; }
  .mt-lg-n2, .my-lg-n2 { margin-top: -0.75rem !important; }
  .mr-lg-n2, .mx-lg-n2 { margin-right: -0.75rem !important; }
  .mb-lg-n2, .my-lg-n2 { margin-bottom: -0.75rem !important; }
  .ml-lg-n2, .mx-lg-n2 { margin-left: -0.75rem !important; }
  .m-lg-n3 { margin: -1rem !important; }
  .mt-lg-n3, .my-lg-n3 { margin-top: -1rem !important; }
  .mr-lg-n3, .mx-lg-n3 { margin-right: -1rem !important; }
  .mb-lg-n3, .my-lg-n3 { margin-bottom: -1rem !important; }
  .ml-lg-n3, .mx-lg-n3 { margin-left: -1rem !important; }
  .m-lg-n4 { margin: -1.5rem !important; }
  .mt-lg-n4, .my-lg-n4 { margin-top: -1.5rem !important; }
  .mr-lg-n4, .mx-lg-n4 { margin-right: -1.5rem !important; }
  .mb-lg-n4, .my-lg-n4 { margin-bottom: -1.5rem !important; }
  .ml-lg-n4, .mx-lg-n4 { margin-left: -1.5rem !important; }
  .m-lg-n5 { margin: -2.75rem !important; }
  .mt-lg-n5, .my-lg-n5 { margin-top: -2.75rem !important; }
  .mr-lg-n5, .mx-lg-n5 { margin-right: -2.75rem !important; }
  .mb-lg-n5, .my-lg-n5 { margin-bottom: -2.75rem !important; }
  .ml-lg-n5, .mx-lg-n5 { margin-left: -2.75rem !important; }
  .m-lg-ngs { margin: -28px !important; }
  .mt-lg-ngs, .my-lg-ngs { margin-top: -28px !important; }
  .mr-lg-ngs, .mx-lg-ngs { margin-right: -28px !important; }
  .mb-lg-ngs, .my-lg-ngs { margin-bottom: -28px !important; }
  .ml-lg-ngs, .mx-lg-ngs { margin-left: -28px !important; }
  .m-lg-auto { margin: auto !important; }
  .mt-lg-auto, .my-lg-auto { margin-top: auto !important; }
  .mr-lg-auto, .mx-lg-auto { margin-right: auto !important; }
  .mb-lg-auto, .my-lg-auto { margin-bottom: auto !important; }
  .ml-lg-auto, .mx-lg-auto { margin-left: auto !important; } }

@media (min-width: 1200px) { .m-xl-0 { margin: 0 !important; }
  .mt-xl-0, .my-xl-0 { margin-top: 0 !important; }
  .mr-xl-0, .mx-xl-0 { margin-right: 0 !important; }
  .mb-xl-0, .my-xl-0 { margin-bottom: 0 !important; }
  .ml-xl-0, .mx-xl-0 { margin-left: 0 !important; }
  .m-xl-1 { margin: 0.375rem !important; }
  .mt-xl-1, .my-xl-1 { margin-top: 0.375rem !important; }
  .mr-xl-1, .mx-xl-1 { margin-right: 0.375rem !important; }
  .mb-xl-1, .my-xl-1 { margin-bottom: 0.375rem !important; }
  .ml-xl-1, .mx-xl-1 { margin-left: 0.375rem !important; }
  .m-xl-2 { margin: 0.75rem !important; }
  .mt-xl-2, .my-xl-2 { margin-top: 0.75rem !important; }
  .mr-xl-2, .mx-xl-2 { margin-right: 0.75rem !important; }
  .mb-xl-2, .my-xl-2 { margin-bottom: 0.75rem !important; }
  .ml-xl-2, .mx-xl-2 { margin-left: 0.75rem !important; }
  .m-xl-3 { margin: 1rem !important; }
  .mt-xl-3, .my-xl-3 { margin-top: 1rem !important; }
  .mr-xl-3, .mx-xl-3 { margin-right: 1rem !important; }
  .mb-xl-3, .my-xl-3 { margin-bottom: 1rem !important; }
  .ml-xl-3, .mx-xl-3 { margin-left: 1rem !important; }
  .m-xl-4 { margin: 1.5rem !important; }
  .mt-xl-4, .my-xl-4 { margin-top: 1.5rem !important; }
  .mr-xl-4, .mx-xl-4 { margin-right: 1.5rem !important; }
  .mb-xl-4, .my-xl-4 { margin-bottom: 1.5rem !important; }
  .ml-xl-4, .mx-xl-4 { margin-left: 1.5rem !important; }
  .m-xl-5 { margin: 2.75rem !important; }
  .mt-xl-5, .my-xl-5 { margin-top: 2.75rem !important; }
  .mr-xl-5, .mx-xl-5 { margin-right: 2.75rem !important; }
  .mb-xl-5, .my-xl-5 { margin-bottom: 2.75rem !important; }
  .ml-xl-5, .mx-xl-5 { margin-left: 2.75rem !important; }
  .m-xl-gs { margin: 28px !important; }
  .mt-xl-gs, .my-xl-gs { margin-top: 28px !important; }
  .mr-xl-gs, .mx-xl-gs { margin-right: 28px !important; }
  .mb-xl-gs, .my-xl-gs { margin-bottom: 28px !important; }
  .ml-xl-gs, .mx-xl-gs { margin-left: 28px !important; }
  .p-xl-0 { padding: 0 !important; }
  .pt-xl-0, .py-xl-0 { padding-top: 0 !important; }
  .pr-xl-0, .px-xl-0 { padding-right: 0 !important; }
  .pb-xl-0, .py-xl-0 { padding-bottom: 0 !important; }
  .pl-xl-0, .px-xl-0 { padding-left: 0 !important; }
  .p-xl-1 { padding: 0.375rem !important; }
  .pt-xl-1, .py-xl-1 { padding-top: 0.375rem !important; }
  .pr-xl-1, .px-xl-1 { padding-right: 0.375rem !important; }
  .pb-xl-1, .py-xl-1 { padding-bottom: 0.375rem !important; }
  .pl-xl-1, .px-xl-1 { padding-left: 0.375rem !important; }
  .p-xl-2 { padding: 0.75rem !important; }
  .pt-xl-2, .py-xl-2 { padding-top: 0.75rem !important; }
  .pr-xl-2, .px-xl-2 { padding-right: 0.75rem !important; }
  .pb-xl-2, .py-xl-2 { padding-bottom: 0.75rem !important; }
  .pl-xl-2, .px-xl-2 { padding-left: 0.75rem !important; }
  .p-xl-3 { padding: 1rem !important; }
  .pt-xl-3, .py-xl-3 { padding-top: 1rem !important; }
  .pr-xl-3, .px-xl-3 { padding-right: 1rem !important; }
  .pb-xl-3, .py-xl-3 { padding-bottom: 1rem !important; }
  .pl-xl-3, .px-xl-3 { padding-left: 1rem !important; }
  .p-xl-4 { padding: 1.5rem !important; }
  .pt-xl-4, .py-xl-4 { padding-top: 1.5rem !important; }
  .pr-xl-4, .px-xl-4 { padding-right: 1.5rem !important; }
  .pb-xl-4, .py-xl-4 { padding-bottom: 1.5rem !important; }
  .pl-xl-4, .px-xl-4 { padding-left: 1.5rem !important; }
  .p-xl-5 { padding: 2.75rem !important; }
  .pt-xl-5, .py-xl-5 { padding-top: 2.75rem !important; }
  .pr-xl-5, .px-xl-5 { padding-right: 2.75rem !important; }
  .pb-xl-5, .py-xl-5 { padding-bottom: 2.75rem !important; }
  .pl-xl-5, .px-xl-5 { padding-left: 2.75rem !important; }
  .p-xl-gs { padding: 28px !important; }
  .pt-xl-gs, .py-xl-gs { padding-top: 28px !important; }
  .pr-xl-gs, .px-xl-gs { padding-right: 28px !important; }
  .pb-xl-gs, .py-xl-gs { padding-bottom: 28px !important; }
  .pl-xl-gs, .px-xl-gs { padding-left: 28px !important; }
  .m-xl-n1 { margin: -0.375rem !important; }
  .mt-xl-n1, .my-xl-n1 { margin-top: -0.375rem !important; }
  .mr-xl-n1, .mx-xl-n1 { margin-right: -0.375rem !important; }
  .mb-xl-n1, .my-xl-n1 { margin-bottom: -0.375rem !important; }
  .ml-xl-n1, .mx-xl-n1 { margin-left: -0.375rem !important; }
  .m-xl-n2 { margin: -0.75rem !important; }
  .mt-xl-n2, .my-xl-n2 { margin-top: -0.75rem !important; }
  .mr-xl-n2, .mx-xl-n2 { margin-right: -0.75rem !important; }
  .mb-xl-n2, .my-xl-n2 { margin-bottom: -0.75rem !important; }
  .ml-xl-n2, .mx-xl-n2 { margin-left: -0.75rem !important; }
  .m-xl-n3 { margin: -1rem !important; }
  .mt-xl-n3, .my-xl-n3 { margin-top: -1rem !important; }
  .mr-xl-n3, .mx-xl-n3 { margin-right: -1rem !important; }
  .mb-xl-n3, .my-xl-n3 { margin-bottom: -1rem !important; }
  .ml-xl-n3, .mx-xl-n3 { margin-left: -1rem !important; }
  .m-xl-n4 { margin: -1.5rem !important; }
  .mt-xl-n4, .my-xl-n4 { margin-top: -1.5rem !important; }
  .mr-xl-n4, .mx-xl-n4 { margin-right: -1.5rem !important; }
  .mb-xl-n4, .my-xl-n4 { margin-bottom: -1.5rem !important; }
  .ml-xl-n4, .mx-xl-n4 { margin-left: -1.5rem !important; }
  .m-xl-n5 { margin: -2.75rem !important; }
  .mt-xl-n5, .my-xl-n5 { margin-top: -2.75rem !important; }
  .mr-xl-n5, .mx-xl-n5 { margin-right: -2.75rem !important; }
  .mb-xl-n5, .my-xl-n5 { margin-bottom: -2.75rem !important; }
  .ml-xl-n5, .mx-xl-n5 { margin-left: -2.75rem !important; }
  .m-xl-ngs { margin: -28px !important; }
  .mt-xl-ngs, .my-xl-ngs { margin-top: -28px !important; }
  .mr-xl-ngs, .mx-xl-ngs { margin-right: -28px !important; }
  .mb-xl-ngs, .my-xl-ngs { margin-bottom: -28px !important; }
  .ml-xl-ngs, .mx-xl-ngs { margin-left: -28px !important; }
  .m-xl-auto { margin: auto !important; }
  .mt-xl-auto, .my-xl-auto { margin-top: auto !important; }
  .mr-xl-auto, .mx-xl-auto { margin-right: auto !important; }
  .mb-xl-auto, .my-xl-auto { margin-bottom: auto !important; }
  .ml-xl-auto, .mx-xl-auto { margin-left: auto !important; } }

@media (min-width: 1540px) { .m-xxl-0 { margin: 0 !important; }
  .mt-xxl-0, .my-xxl-0 { margin-top: 0 !important; }
  .mr-xxl-0, .mx-xxl-0 { margin-right: 0 !important; }
  .mb-xxl-0, .my-xxl-0 { margin-bottom: 0 !important; }
  .ml-xxl-0, .mx-xxl-0 { margin-left: 0 !important; }
  .m-xxl-1 { margin: 0.375rem !important; }
  .mt-xxl-1, .my-xxl-1 { margin-top: 0.375rem !important; }
  .mr-xxl-1, .mx-xxl-1 { margin-right: 0.375rem !important; }
  .mb-xxl-1, .my-xxl-1 { margin-bottom: 0.375rem !important; }
  .ml-xxl-1, .mx-xxl-1 { margin-left: 0.375rem !important; }
  .m-xxl-2 { margin: 0.75rem !important; }
  .mt-xxl-2, .my-xxl-2 { margin-top: 0.75rem !important; }
  .mr-xxl-2, .mx-xxl-2 { margin-right: 0.75rem !important; }
  .mb-xxl-2, .my-xxl-2 { margin-bottom: 0.75rem !important; }
  .ml-xxl-2, .mx-xxl-2 { margin-left: 0.75rem !important; }
  .m-xxl-3 { margin: 1rem !important; }
  .mt-xxl-3, .my-xxl-3 { margin-top: 1rem !important; }
  .mr-xxl-3, .mx-xxl-3 { margin-right: 1rem !important; }
  .mb-xxl-3, .my-xxl-3 { margin-bottom: 1rem !important; }
  .ml-xxl-3, .mx-xxl-3 { margin-left: 1rem !important; }
  .m-xxl-4 { margin: 1.5rem !important; }
  .mt-xxl-4, .my-xxl-4 { margin-top: 1.5rem !important; }
  .mr-xxl-4, .mx-xxl-4 { margin-right: 1.5rem !important; }
  .mb-xxl-4, .my-xxl-4 { margin-bottom: 1.5rem !important; }
  .ml-xxl-4, .mx-xxl-4 { margin-left: 1.5rem !important; }
  .m-xxl-5 { margin: 2.75rem !important; }
  .mt-xxl-5, .my-xxl-5 { margin-top: 2.75rem !important; }
  .mr-xxl-5, .mx-xxl-5 { margin-right: 2.75rem !important; }
  .mb-xxl-5, .my-xxl-5 { margin-bottom: 2.75rem !important; }
  .ml-xxl-5, .mx-xxl-5 { margin-left: 2.75rem !important; }
  .m-xxl-gs { margin: 28px !important; }
  .mt-xxl-gs, .my-xxl-gs { margin-top: 28px !important; }
  .mr-xxl-gs, .mx-xxl-gs { margin-right: 28px !important; }
  .mb-xxl-gs, .my-xxl-gs { margin-bottom: 28px !important; }
  .ml-xxl-gs, .mx-xxl-gs { margin-left: 28px !important; }
  .p-xxl-0 { padding: 0 !important; }
  .pt-xxl-0, .py-xxl-0 { padding-top: 0 !important; }
  .pr-xxl-0, .px-xxl-0 { padding-right: 0 !important; }
  .pb-xxl-0, .py-xxl-0 { padding-bottom: 0 !important; }
  .pl-xxl-0, .px-xxl-0 { padding-left: 0 !important; }
  .p-xxl-1 { padding: 0.375rem !important; }
  .pt-xxl-1, .py-xxl-1 { padding-top: 0.375rem !important; }
  .pr-xxl-1, .px-xxl-1 { padding-right: 0.375rem !important; }
  .pb-xxl-1, .py-xxl-1 { padding-bottom: 0.375rem !important; }
  .pl-xxl-1, .px-xxl-1 { padding-left: 0.375rem !important; }
  .p-xxl-2 { padding: 0.75rem !important; }
  .pt-xxl-2, .py-xxl-2 { padding-top: 0.75rem !important; }
  .pr-xxl-2, .px-xxl-2 { padding-right: 0.75rem !important; }
  .pb-xxl-2, .py-xxl-2 { padding-bottom: 0.75rem !important; }
  .pl-xxl-2, .px-xxl-2 { padding-left: 0.75rem !important; }
  .p-xxl-3 { padding: 1rem !important; }
  .pt-xxl-3, .py-xxl-3 { padding-top: 1rem !important; }
  .pr-xxl-3, .px-xxl-3 { padding-right: 1rem !important; }
  .pb-xxl-3, .py-xxl-3 { padding-bottom: 1rem !important; }
  .pl-xxl-3, .px-xxl-3 { padding-left: 1rem !important; }
  .p-xxl-4 { padding: 1.5rem !important; }
  .pt-xxl-4, .py-xxl-4 { padding-top: 1.5rem !important; }
  .pr-xxl-4, .px-xxl-4 { padding-right: 1.5rem !important; }
  .pb-xxl-4, .py-xxl-4 { padding-bottom: 1.5rem !important; }
  .pl-xxl-4, .px-xxl-4 { padding-left: 1.5rem !important; }
  .p-xxl-5 { padding: 2.75rem !important; }
  .pt-xxl-5, .py-xxl-5 { padding-top: 2.75rem !important; }
  .pr-xxl-5, .px-xxl-5 { padding-right: 2.75rem !important; }
  .pb-xxl-5, .py-xxl-5 { padding-bottom: 2.75rem !important; }
  .pl-xxl-5, .px-xxl-5 { padding-left: 2.75rem !important; }
  .p-xxl-gs { padding: 28px !important; }
  .pt-xxl-gs, .py-xxl-gs { padding-top: 28px !important; }
  .pr-xxl-gs, .px-xxl-gs { padding-right: 28px !important; }
  .pb-xxl-gs, .py-xxl-gs { padding-bottom: 28px !important; }
  .pl-xxl-gs, .px-xxl-gs { padding-left: 28px !important; }
  .m-xxl-n1 { margin: -0.375rem !important; }
  .mt-xxl-n1, .my-xxl-n1 { margin-top: -0.375rem !important; }
  .mr-xxl-n1, .mx-xxl-n1 { margin-right: -0.375rem !important; }
  .mb-xxl-n1, .my-xxl-n1 { margin-bottom: -0.375rem !important; }
  .ml-xxl-n1, .mx-xxl-n1 { margin-left: -0.375rem !important; }
  .m-xxl-n2 { margin: -0.75rem !important; }
  .mt-xxl-n2, .my-xxl-n2 { margin-top: -0.75rem !important; }
  .mr-xxl-n2, .mx-xxl-n2 { margin-right: -0.75rem !important; }
  .mb-xxl-n2, .my-xxl-n2 { margin-bottom: -0.75rem !important; }
  .ml-xxl-n2, .mx-xxl-n2 { margin-left: -0.75rem !important; }
  .m-xxl-n3 { margin: -1rem !important; }
  .mt-xxl-n3, .my-xxl-n3 { margin-top: -1rem !important; }
  .mr-xxl-n3, .mx-xxl-n3 { margin-right: -1rem !important; }
  .mb-xxl-n3, .my-xxl-n3 { margin-bottom: -1rem !important; }
  .ml-xxl-n3, .mx-xxl-n3 { margin-left: -1rem !important; }
  .m-xxl-n4 { margin: -1.5rem !important; }
  .mt-xxl-n4, .my-xxl-n4 { margin-top: -1.5rem !important; }
  .mr-xxl-n4, .mx-xxl-n4 { margin-right: -1.5rem !important; }
  .mb-xxl-n4, .my-xxl-n4 { margin-bottom: -1.5rem !important; }
  .ml-xxl-n4, .mx-xxl-n4 { margin-left: -1.5rem !important; }
  .m-xxl-n5 { margin: -2.75rem !important; }
  .mt-xxl-n5, .my-xxl-n5 { margin-top: -2.75rem !important; }
  .mr-xxl-n5, .mx-xxl-n5 { margin-right: -2.75rem !important; }
  .mb-xxl-n5, .my-xxl-n5 { margin-bottom: -2.75rem !important; }
  .ml-xxl-n5, .mx-xxl-n5 { margin-left: -2.75rem !important; }
  .m-xxl-ngs { margin: -28px !important; }
  .mt-xxl-ngs, .my-xxl-ngs { margin-top: -28px !important; }
  .mr-xxl-ngs, .mx-xxl-ngs { margin-right: -28px !important; }
  .mb-xxl-ngs, .my-xxl-ngs { margin-bottom: -28px !important; }
  .ml-xxl-ngs, .mx-xxl-ngs { margin-left: -28px !important; }
  .m-xxl-auto { margin: auto !important; }
  .mt-xxl-auto, .my-xxl-auto { margin-top: auto !important; }
  .mr-xxl-auto, .mx-xxl-auto { margin-right: auto !important; }
  .mb-xxl-auto, .my-xxl-auto { margin-bottom: auto !important; }
  .ml-xxl-auto, .mx-xxl-auto { margin-left: auto !important; } }

.stretched-link::after { position: absolute; top: 0; right: 0; bottom: 0; left: 0; z-index: 1; pointer-events: auto; content: ""; background-color: rgba(0, 0, 0, 0); }

.text-monospace, .ff-mono { font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace !important; }

.text-justify { text-align: justify !important; }

.text-wrap { white-space: normal !important; }

.text-nowrap { white-space: nowrap !important; }

.text-truncate { overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }

.text-left { text-align: left !important; }

.text-right { text-align: right !important; }

.text-center { text-align: center !important; }





.w-40px { width: 40px !important; }

.w-min-40px { min-width: 40px !important; }

.w-max-40px { max-width: 40px !important; }

.w-80px { width: 80px !important; }

.w-min-80px { min-width: 80px !important; }

.w-max-80px { max-width: 80px !important; }

.w-90px { width: 90px !important; }

.w-min-90px { min-width: 90px !important; }

.w-max-90px { max-width: 90px !important; }

.w-100px { width: 100px !important; }

.w-min-100px { min-width: 100px !important; }

.w-max-100px { max-width: 100px !important; }

.w-110px { width: 110px !important; }

.w-min-110px { min-width: 110px !important; }

.w-max-110px { max-width: 110px !important; }

.w-120px { width: 120px !important; }

.w-min-120px { min-width: 120px !important; }

.w-max-120px { max-width: 120px !important; }

.w-125px { width: 125px !important; }

.w-min-125px { min-width: 125px !important; }

.w-max-125px { max-width: 125px !important; }

.w-130px { width: 130px !important; }

.w-min-130px { min-width: 130px !important; }

.w-max-130px { max-width: 130px !important; }

.w-140px { width: 140px !important; }

.w-min-140px { min-width: 140px !important; }

.w-max-140px { max-width: 140px !important; }

.w-150px { width: 150px !important; }

.w-min-150px { min-width: 150px !important; }

.w-max-150px { max-width: 150px !important; }

.w-175px { width: 175px !important; }

.w-min-175px { min-width: 175px !important; }

.w-max-175px { max-width: 175px !important; }

.w-200px { width: 200px !important; }

.w-min-200px { min-width: 200px !important; }

.w-max-200px { max-width: 200px !important; }

.w-220px { width: 220px !important; }

.w-min-220px { min-width: 220px !important; }

.w-max-220px { max-width: 220px !important; }

.w-225px { width: 225px !important; }

.w-min-225px { min-width: 225px !important; }

.w-max-225px { max-width: 225px !important; }

.w-250px { width: 250px !important; }

.w-min-250px { min-width: 250px !important; }

.w-max-250px { max-width: 250px !important; }

.w-300px { width: 300px !important; }

.w-min-300px { min-width: 300px !important; }

.w-max-300px { max-width: 300px !important; }

.w-350px { width: 350px !important; }

.w-min-350px { min-width: 350px !important; }

.w-max-350px { max-width: 350px !important; }

.w-400px { width: 400px !important; }

.w-min-400px { min-width: 400px !important; }

.w-max-400px { max-width: 400px !important; }

.w-550px { width: 550px !important; }

.w-min-550px { min-width: 550px !important; }

.w-max-550px { max-width: 550px !important; }

.w-max-100, .wide-xs-fix, .wide-sm-fix, .wide-md-fix, .wide-lg-fix { max-width: 100% !important; }

.w-min-100 { min-width: 100% !important; }

.w-max-auto { max-width: inherit !important; }

.w-min-auto { min-width: auto !important; }

.w-15 { width: 15% !important; }

.w-20 { width: 20% !important; }

.w-30 { width: 30% !important; }

.w-35 { width: 35% !important; }

.w-40 { width: 40% !important; }

.w-45 { width: 45% !important; }

.w-55 { width: 55% !important; }

.w-60 { width: 60% !important; }

.w-65 { width: 65% !important; }

.w-70 { width: 70% !important; }

.w-80 { width: 80% !important; }

.w-85 { width: 85% !important; }

.w-90 { width: 90% !important; }

.w-95 { width: 95% !important; }

@media (min-width: 576px) { .wide-xs { max-width: 520px !important; }
  .wide-xs-fix { width: 520px !important; } }

@media (min-width: 768px) { .wide-sm { max-width: 720px !important; }
  .wide-sm-fix { width: 720px !important; } }

@media (min-width: 992px) { .wide-md { max-width: 960px !important; }
  .wide-md-fix { width: 960px !important; } }

@media (min-width: 1200px) { .wide-lg { max-width: 1140px !important; }
  .wide-lg-fix { width: 1140px !important; } }

@media (min-width: 1280px) { .wide-xl { max-width: 1240px !important; }
  .wide-xl-fix { width: 1240px !important; } }

.wide-xs-fix { width: 520px !important; }

.wide-sm-fix { width: 720px !important; }

.wide-md-fix { width: 960px !important; }

.wide-lg-fix { width: 1140px !important; }

.wide-xl-fix { width: 1240px !important; }

@media (min-width: 1200px) and (max-width: 1660px) { .wide-fit { max-width: 1140px; } }

.h-100px { height: 100px !important; }

.h-min-100px { min-height: 100px !important; }

.h-max-100px { max-height: 100px !important; }

.h-150px { height: 150px !important; }

.h-min-150px { min-height: 150px !important; }

.h-max-150px { max-height: 150px !important; }

.h-175px { height: 175px !important; }

.h-min-175px { min-height: 175px !important; }

.h-max-175px { max-height: 175px !important; }

.h-200px { height: 200px !important; }

.h-min-200px { min-height: 200px !important; }

.h-max-200px { max-height: 200px !important; }

.h-225px { height: 225px !important; }

.h-min-225px { min-height: 225px !important; }

.h-max-225px { max-height: 225px !important; }

.h-250px { height: 250px !important; }

.h-min-250px { min-height: 250px !important; }

.h-max-250px { max-height: 250px !important; }

.h-275px { height: 275px !important; }

.h-min-275px { min-height: 275px !important; }

.h-max-275px { max-height: 275px !important; }

.h-300px { height: 300px !important; }

.h-min-300px { min-height: 300px !important; }

.h-max-300px { max-height: 300px !important; }

.h-325px { height: 325px !important; }

.h-min-325px { min-height: 325px !important; }

.h-max-325px { max-height: 325px !important; }

.h-350px { height: 350px !important; }

.h-min-350px { min-height: 350px !important; }

.h-max-350px { max-height: 350px !important; }

.h-375px { height: 375px !important; }

.h-min-375px { min-height: 375px !important; }

.h-max-375px { max-height: 375px !important; }

.h-400px { height: 400px !important; }

.h-min-400px { min-height: 400px !important; }

.h-max-400px { max-height: 400px !important; }

.h-425px { height: 425px !important; }

.h-min-425px { min-height: 425px !important; }

.h-max-425px { max-height: 425px !important; }

.h-450px { height: 450px !important; }

.h-min-450px { min-height: 450px !important; }

.h-max-450px { max-height: 450px !important; }

.h-475px { height: 475px !important; }

.h-min-475px { min-height: 475px !important; }

.h-max-475px { max-height: 475px !important; }

.h-500px { height: 500px !important; }

.h-min-500px { min-height: 500px !important; }

.h-max-500px { max-height: 500px !important; }

.absolute-top-left { position: absolute; top: 0; left: 0; }

.absolute-top-right { position: absolute; top: 0; right: 0; }

.absolute-bottom-left { position: absolute; bottom: 0; left: 0; }

.absolute-bottom-right { position: absolute; bottom: 0; right: 0; }

.shrink-0 { flex-shrink: 0; }

.badge { position: relative; border: 1px solid currentColor; line-height: 1.125rem; font-family: Roboto, sans-serif; letter-spacing: 0.01em; vertical-align: middle; display: inline-flex; }

.badge .icon + span, .badge span + .icon { padding-left: 4px; }

.badge-sm { padding: 0.3125rem 0.75rem; font-size: 0.75rem; }

.badge-sm.badge-pill { padding: 0.3125rem 0.875rem; }

.badge-md { padding: 0.47rem 1rem; font-size: 0.8125rem !important; }

.badge-lg { padding: 0.75rem 1.25rem; font-size: 0.93rem !important; }

.badge-xl { padding: 0.875rem 1.5rem; font-size: 1.125rem !important; }

.badge-light { color: #364a63; }

.badge-lighter { color: #526484; }

.badge .icon { font-size: 1rem; }

.badge-primary { border-color: #0971fe; }

.badge-secondary { border-color: #364a63; }

.badge-success { border-color: #1ee0ac; }

.badge-info { border-color: #09c2de; }

.badge-warning { border-color: #f4bd0e; }

.badge-danger { border-color: #e85347; }

.badge-dark { border-color: #1c2b46; }

.badge-gray { border-color: #8091a7; }

.badge-light { border-color: #e5e9f2; }

.badge-lighter { border-color: #f5f6fa; }

.badge-outline-primary { color: #0971fe; border-color: #6baafe; }

.badge-outline-secondary { color: #364a63; border-color: #8692a1; }

.badge-outline-success { color: #1ee0ac; border-color: #78eccd; }

.badge-outline-info { color: #09c2de; border-color: #6bdaeb; }

.badge-outline-warning { color: #f4bd0e; border-color: #f8d76e; }

.badge-outline-danger { color: #e85347; border-color: #f19891; }

.badge-outline-dark { color: #1c2b46; border-color: #778090; }

.badge-outline-gray { color: #8091a7; border-color: #b3bdca; }

.badge-outline-light { color: #b7c2d0; border-color: #d4dae3; }

.badge-outline-lighter { color: #e5e9f2; border-color: #eff2f7; }

.badge-dim.badge-primary { color: #0971fe; background-color: #e4efff; border-color: #e4efff; }

.badge-dim.badge-outline-primary { color: #0971fe; background-color: #e4efff; border-color: #9dc6ff; }

.badge-dim.badge-secondary { color: #364a63; background-color: #e9ebee; border-color: #e9ebee; }

.badge-dim.badge-outline-secondary { color: #364a63; background-color: #e9ebee; border-color: #afb7c1; }

.badge-dim.badge-success { color: #1ee0ac; background-color: #e6fcf6; border-color: #e6fcf6; }

.badge-dim.badge-outline-success { color: #1ee0ac; background-color: #e6fcf6; border-color: #a5f3de; }

.badge-dim.badge-info { color: #09c2de; background-color: #e4f8fb; border-color: #e4f8fb; }

.badge-dim.badge-outline-info { color: #09c2de; background-color: #e4f8fb; border-color: #9de7f2; }

.badge-dim.badge-warning { color: #f4bd0e; background-color: #fef8e4; border-color: #fef8e4; }

.badge-dim.badge-outline-warning { color: #f4bd0e; background-color: #fef8e4; border-color: #fbe59f; }

.badge-dim.badge-danger { color: #e85347; background-color: #fceceb; border-color: #fceceb; }

.badge-dim.badge-outline-danger { color: #e85347; background-color: #fceceb; border-color: #f6bab5; }

.badge-dim.badge-dark { color: #1c2b46; background-color: #e6e8eb; border-color: #e6e8eb; }

.badge-dim.badge-outline-dark { color: #1c2b46; background-color: #e6e8eb; border-color: #a4aab5; }

.badge-dim.badge-gray { color: #8091a7; background-color: #f1f3f5; border-color: #f1f3f5; }

.badge-dim.badge-outline-gray { color: #8091a7; background-color: #f1f3f5; border-color: #ccd3dc; }

.badge-dim.badge-light { color: #b7c2d0; background-color: #f7f8fa; border-color: #f7f8fa; }

.badge-dim.badge-outline-light { color: #b7c2d0; background-color: #f7f8fa; border-color: #e2e7ec; }

.badge-dim.badge-lighter { color: #e5e9f2; background-color: #fcfdfe; border-color: #fcfdfe; }

.badge-dim.badge-outline-lighter { color: #e5e9f2; background-color: #fcfdfe; border-color: #f5f6fa; }

.badge-dot { display: inline-flex; align-items: center; background-color: transparent; border: none; padding-left: 12px; padding-right: 0; font-size: 12px; }

.badge-dot:before { position: absolute; content: ""; left: 0; top: 50%; transform: translateY(-50%); display: inline-block; height: 6px; width: 6px; margin-top: -1px; border-radius: 50%; background: currentColor; }

.badge-dot.badge-sm, .badge-dot.badge-md { padding-left: 16px; }

.badge-dot.badge-sm:before, .badge-dot.badge-md:before { height: 8px; width: 8px; margin-top: 0; }

.badge-dot.badge-lg, .badge-dot.badge-xl { padding-left: 24px; }

.badge-dot.badge-lg:before, .badge-dot.badge-xl:before { height: 12px; width: 12px; margin-top: 0; }

.badge-dot.badge-primary { color: #0971fe; }

.badge-dot.badge-secondary { color: #364a63; }

.badge-dot.badge-success { color: #1ee0ac; }

.badge-dot.badge-info { color: #09c2de; }

.badge-dot.badge-warning { color: #f4bd0e; }

.badge-dot.badge-danger { color: #e85347; }

.badge-dot.badge-dark { color: #1c2b46; }

.badge-dot.badge-gray { color: #8091a7; }

.badge-dot.badge-light { color: #b7c2d0; }

.badge-dot.badge-lighter { color: #e5e9f2; }

@media (max-width: 767.98px) { .badge-dot-sm { width: 0; overflow: hidden; } }

@media (max-width: 413px) { .badge-dot-mb { width: 0; overflow: hidden; } }

@media (max-width: 369px) { .badge-dot-xs { width: 0; overflow: hidden; } }


@media (max-width: 576px) { .dark-mode .nk-block-tools-toggle .toggle-expand-content { background-color: #212d3d; } }


.card {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    overflow: hidden;
}

.card-icon {
    width: 60px;
    height: 60px;
    margin: 0 auto;
}

.card-icon svg {
    width: 100%;
    height: 100%;
    fill: #007bff;
}

.card-title {
    font-size: 1.25rem;
    margin-bottom: 0.5rem;
}

.card-text {
    font-size: 0.875rem;
    margin-bottom: 1rem;
}

.card-body {
    padding: 1rem;
}

.btn-info {
    background-color: #13c636f;
    border-color: #13c636;
}

.btn-info:hover {
    background-color: #0c9427;
    border-color: #0c9427;
}

  /* Custom styles for responsive layout */
        .card-inner {
            padding: 20px;
        }

        .nk-block-image {
            text-align: left;
        }

        .nk-block-image img {
            max-width: 100%;
            height: auto;
            margin-bottom: 10px;
        }

        .nk-block-content {
            margin-left: 10px;
        }

        .btn-outline-primary {
            padding: 10px 20px;
            font-size: 16px;
            display: inline-flex;
            align-items: center;
        }

        @media (max-width: 767.98px) {
            .nk-block-image {
                text-align: center;
            }

            .nk-block-content {
                text-align: center;
                margin-left: 0;
            }

            .btn-outline-primary {
                width: 100%;
                text-align: center;
            }
        }

        @media (min-width: 768px) {
            .nk-block-image img {
                width: 100px;
                height: auto;
            }
        }

        @media (min-width: 992px) {
            .nk-block-image img {
                width: 120px;
                height: auto;
            }
        }

        @media (min-width: 1200px) {
            .nk-block-image img {
                width: 150px;
                height: auto;
            }
        }
        
        /* Custom CSS for the modal */
.error-icon {
    font-size: 100px;
    color: #ff4d4d; /* Red color for the error icon */
}

.modal-title {
    font-size: 1.5rem;
    font-weight: bold;
    margin-top: 20px;
}

/* Custom button styling */
.custom-btn {
    background-color: #199d18; 
    color: #fff; 
    border: none; 
    padding: 5px 10px; 
    font-size: 0.7rem;
    border-radius: 5px; 
    transition: background-color 0.3s ease; 
}

.custom-btn:hover {
    background-color: #13c636; 
    color: #ffffff;
}

.position-relative {
    position: relative;
    display: inline-block;
    max-width: 100%; 
}

.monitor-gif {
    width: 100%; 
    height: auto; 
}

.live-gif {
    position: absolute;
    top: 0; 
    right: 0; 
    width: 25%; 
    max-width: 60px; 
    height: auto; 
    z-index: 10; 


}


  </style>   
    <x-danger-alert />
    <x-success-alert />
    <x-alert />
    
    <div class="container mb-4">
        <div class="row">
            <div class="col-12">
                <input type="text" id="searchInput" class="form-control" placeholder="Search for files..." onkeyup="searchFiles()">
            </div>
        </div>
    </div>
    <h3>Trading Resources</h3>
    <div class="nk-block-head">
        <div class="nk-block-head-content">
            <div class="nk-block-des">
                <p>Trading PDFs and courses that can help deepen your understanding of various trading strategies and concepts. Each PDF file contains videos for each course, which will deepen your knowledge and give you a broad understanding.</p>
            </div>
        </div>
    </div>
    
    <div class="card-inner">
    <div class="align-center justify-content-between flex-wrap flex-md-nowrap g-4">
        <div class="nk-block-image w-120px flex-shrink-0 position-relative">
            <!-- Monitor GIF -->
            <img src="{{ asset('storage/app/public/photos/monitor.gif') }}" alt="Monitor GIF" class="monitor-gif">

            <!-- Live GIF (positioned at the top-right corner) -->
            <img src="{{ asset('storage/app/public/photos/live.gif') }}" alt="Live GIF" class="live-gif">
        </div>
        <div class="nk-block-content">
            <div class="nk-block-content-head px-lg-4">
                <h3>LIVE TRADING SESSION</h3>
            </div>
        </div>
        <div class="nk-block-content flex-shrink-0">
            <button data-toggle="modal" data-target="#durationModal" type="button" class="btn btn-lg btn-outline-primary">
                Click to join &nbsp;&nbsp;<i class="fa-solid fa-lock"></i>
            </button>
        </div>
    </div>
</div>


       <div class="container">
    <div class="row">
                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">The Profitable Trader</h3>
            <p class="card-text">
                Pdf<br>
                89,949.61 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 79 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Win, Loss Balance</h3>
            <p class="card-text">
                Pdf<br>
                711.22 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 757 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Risk-Reward Ratio</h3>
            <p class="card-text">
                Pdf<br>
                1,609.59 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 443 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Emotions Management</h3>
            <p class="card-text">
                Pdf<br>
                468.53 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 231 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Market Wizards</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 2000 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Trading psychology</h3>
            <p class="card-text">
                Video<br>
                2,587.26 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 1000 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Mastering the Trade</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 199 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">understanding Trend Trading</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 1500 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Candle Story</h3>
            <p class="card-text">
                Pdf<br>
                242.39 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 4467 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Revised Full SMT concept</h3>
            <p class="card-text">
                Video<br>
                40.88 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 120794 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Full ICT concept</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 180599 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Quantitative Trading</h3>
            <p class="card-text">
                Pdf<br>
                40.88 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 13500 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Day Trading and Swing Trading</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 9486 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Risk Management in Trading</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 30599 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Understanding Forex Pairs</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 6610 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Trading the News</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 10733 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Creating Your Own Trading Journal</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 11740 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Using Multiple Timeframes</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 13955 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Understanding Stop Loss and Take Profit</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 10000 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Developing a Winning Trading Mindset</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 6045 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Trading Commodities</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 7900 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Using Multiple Timeframes</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 10594 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Swing Trading for Dummies</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 7009 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/pdf.png') }}" alt="PDF Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Day Trading for Dummies</h3>
            <p class="card-text">
                Pdf<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 18006 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Options, Futures, and Other Derivatives</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 17566 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Elliott Wave Formular</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 65900 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Trading in the Zone</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 104833 users
            </h5>
        </div>
    </div>
</div>

                   <div class="col-12 col-md-6 col-lg-4 mb-4">
    <div class="card h-100">
        <div class="card-body text-center d-flex flex-column">
            <div class="card-icon mb-3 position-relative">
                                    <img src="{{ asset('storage/app/public/photos/video.png') }}" alt="Video Icon" class="monitor-gif">
                            </div>
            <h3 class="mb-0 card-title">Millionaire Traders</h3>
            <p class="card-text">
                Video<br>
                3,354.71 KB
            </p>

                            <button class="btn btn-lg btn-outline-secondary mt-auto" data-toggle="modal" data-target="#durationModal">Locked&nbsp;<i class="fa-solid fa-lock"></i></button>
            
            <h5 class="d-flex align-items-center text-muted fw-semibold mt-3">
                <span class="legend-circle-sm bg-success"></span>
                Accessed by 110086 users
            </h5>
        </div>
    </div>
</div>

            </div>
</div>


        
        
        
    
    
   <div id="durationModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-dialog-centered" style="max-width: 90%; width: 400px; margin: auto;">
        <div class="modal-content">
            <div class="modal-body modal-body-md position-relative p-4">
                <!-- Close Button -->
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: absolute; top: 7px; right: 7px;">
                    <span aria-hidden="true">&times;</span>
                </button>

                <!-- Centered Content -->
                <div class="text-center">
                    <div class="tab-content">
                        <br>
                        <p style="color:#2d2d2d; margin-bottom: 0;">For more details about our trading resource and academy, please reach out to our support team via email or live chat. <a href="{{ route('support') }}"><b>Chat Now</b></a></p>
                        <br>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
    function searchFiles() {
    // Get the search input value
    const searchInput = document.getElementById('searchInput').value.toLowerCase();
    
    // Get all file cards
    const fileCards = document.querySelectorAll('.card');
    
    // Loop through all file cards
    fileCards.forEach(card => {
        const fileName = card.querySelector('.card-title').textContent.toLowerCase();
        
        // Check if file name matches the search query
        if (fileName.includes(searchInput)) {
            card.style.display = 'block'; // Show matching file cards
        } else {
            card.style.display = 'none'; // Hide non-matching file cards
        }
    });
}

</script>

        </div>
@endsection
